/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class PopupPositionManager {
    private PopupPositionManager() {
    }

    public static void positionPopupInBestPosition(final JBPopup hint, @Nullable Editor editor, @Nullable DataContext dataContext) {
        LookupEx lookup = LookupManager.getActiveLookup(editor);
        if (lookup != null && lookup.getCurrentItem() != null && lookup.getComponent().isShowing()) {
            new PositionAdjuster(lookup.getComponent()).adjust(hint);
            lookup.addLookupListener(new LookupAdapter(){

                @Override
                public void lookupCanceled(LookupEvent event) {
                    if (hint.isVisible()) {
                        hint.cancel();
                    }
                }
            });
            return;
        }
        PositionAdjuster positionAdjuster = PopupPositionManager.createPositionAdjuster();
        if (positionAdjuster != null) {
            positionAdjuster.adjust(hint);
            return;
        }
        if (editor != null && editor.getComponent().isShowing()) {
            hint.showInBestPositionFor(editor);
            return;
        }
        if (dataContext != null) {
            hint.showInBestPositionFor(dataContext);
        }
    }

    private static Component discoverPopup(DataKey<JBPopup> datakey, Component focusOwner) {
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        if (dataContext == null) {
            return null;
        }
        JBPopup popup = (JBPopup)datakey.getData(dataContext);
        if (popup != null && popup.isVisible()) {
            return popup.getContent();
        }
        return null;
    }

    @Nullable
    private static PositionAdjuster createPositionAdjuster() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return null;
        }
        if (focusOwner instanceof JBList) {
            return new PositionAdjuster(SwingUtilities.getWindowAncestor(focusOwner));
        }
        Component existing = PopupPositionManager.discoverPopup((DataKey<JBPopup>)LangDataKeys.POSITION_ADJUSTER_POPUP, focusOwner);
        if (existing != null) {
            return new PositionAdjuster2(existing, PopupPositionManager.discoverPopup((DataKey<JBPopup>)LangDataKeys.PARENT_POPUP, focusOwner));
        }
        return null;
    }

    public static class PositionAdjuster {
        protected final int myGap;
        protected final Component myRelativeTo;
        protected final Point myRelativeOnScreen;
        protected final Rectangle myScreenRect;

        public PositionAdjuster(Component relativeTo, int gap) {
            this.myRelativeTo = relativeTo;
            this.myRelativeOnScreen = relativeTo.getLocationOnScreen();
            this.myScreenRect = ScreenUtil.getScreenRectangle((Point)this.myRelativeOnScreen);
            this.myGap = gap;
        }

        public PositionAdjuster(Component relativeTo) {
            this(relativeTo, 5);
        }

        protected Rectangle positionRight(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.myRelativeOnScreen.y, d.width, d.height);
        }

        protected Rectangle positionLeft(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x - this.myGap - d.width, this.myRelativeOnScreen.y, d.width, d.height);
        }

        protected Rectangle positionAbove(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x, this.getYForTopPositioning() - this.myGap - d.height, d.width, d.height);
        }

        protected Rectangle positionUnder(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x, this.myRelativeOnScreen.y + this.myGap + this.myRelativeTo.getHeight(), d.width, d.height);
        }

        protected int getYForTopPositioning() {
            return this.myRelativeOnScreen.y;
        }

        public void adjust(JBPopup popup) {
            this.adjust(popup, Position.RIGHT, Position.LEFT, Position.TOP, Position.BOTTOM);
        }

        public void adjust(JBPopup popup, Position ... traversalPolicy) {
            Dimension d = PositionAdjuster.getPopupSize(popup);
            Rectangle popupRect = null;
            Rectangle r = null;
            for (Position position : traversalPolicy) {
                switch (position) {
                    case TOP: {
                        r = this.positionAbove(d);
                        break;
                    }
                    case BOTTOM: {
                        r = this.positionUnder(d);
                        break;
                    }
                    case LEFT: {
                        r = this.positionLeft(d);
                        break;
                    }
                    case RIGHT: {
                        r = this.positionRight(d);
                    }
                }
                if (!this.myScreenRect.contains(r)) continue;
                popupRect = r;
                break;
            }
            if (popupRect != null) {
                if (popup.isVisible()) {
                    popup.setLocation(new Point(r.x, r.y));
                } else {
                    Point p = new Point(r.x - this.myRelativeOnScreen.x, r.y - this.myRelativeOnScreen.y);
                    popup.show(new RelativePoint(this.myRelativeTo, p));
                }
            } else {
                ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
                boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.myRelativeOnScreen.y, this.myScreenRect.width, this.myScreenRect.height)));
                boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myScreenRect.x, this.myRelativeOnScreen.y, this.myRelativeOnScreen.x - this.myScreenRect.x - this.myGap, this.myScreenRect.height)));
                boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x, this.myScreenRect.y, this.myScreenRect.width, this.getYForTopPositioning() - this.myScreenRect.y - this.myGap)));
                boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x, this.myRelativeOnScreen.y + this.myRelativeTo.getHeight() + this.myGap, this.myScreenRect.width, this.myScreenRect.height)));
                Collections.sort(boxes, (o1, o2) -> {
                    int i2 = Integer.compare(o1.width, o2.width);
                    return i2 == 0 ? Integer.compare(o1.height, o2.height) : i2;
                });
                Rectangle suitableBox = (Rectangle)boxes.get(boxes.size() - 1);
                Rectangle crop = PositionAdjuster.crop(suitableBox, new Rectangle(suitableBox.x < this.myRelativeOnScreen.x ? suitableBox.x + suitableBox.width - d.width : suitableBox.x, suitableBox.y < this.myRelativeOnScreen.y ? suitableBox.y + suitableBox.height - d.height : suitableBox.y, d.width, d.height));
                popup.setSize(crop.getSize());
                if (popup.isVisible()) {
                    popup.setLocation(crop.getLocation());
                } else {
                    popup.show(new RelativePoint(this.myRelativeTo, new Point(crop.getLocation().x - this.myRelativeOnScreen.x, crop.getLocation().y - this.myRelativeOnScreen.y)));
                }
            }
        }

        protected static Rectangle crop(Rectangle source, Rectangle toCrop) {
            Rectangle result2 = new Rectangle(toCrop);
            if (toCrop.x < source.x) {
                result2.width -= source.x - toCrop.x;
                result2.x = source.x;
            }
            if (toCrop.y < source.y) {
                result2.height -= source.y - toCrop.y;
                result2.y = source.y;
            }
            if (result2.x + result2.width > source.x + source.width) {
                result2.width = source.x + source.width - result2.x;
            }
            if (result2.y + result2.height > source.y + source.height) {
                result2.height = source.y + source.height - result2.y;
            }
            return result2;
        }

        public static Dimension getPopupSize(JBPopup popup) {
            String dimensionKey;
            Dimension size = null;
            if (popup instanceof AbstractPopup && (dimensionKey = ((AbstractPopup)popup).getDimensionServiceKey()) != null) {
                size = DimensionService.getInstance().getSize(dimensionKey);
            }
            if (size == null) {
                size = popup.getContent().getPreferredSize();
            }
            return size;
        }
    }

    private static class PositionAdjuster2
    extends PositionAdjuster {
        private final Component myTopComponent;

        private PositionAdjuster2(Component relativeTo, Component topComponent) {
            super(relativeTo);
            this.myTopComponent = topComponent == null ? relativeTo : topComponent;
        }

        @Override
        protected int getYForTopPositioning() {
            return this.myTopComponent.getLocationOnScreen().y;
        }
    }

    public static enum Position {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

