/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorsConfigurablePanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FileColorsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private FileColorsConfigurablePanel myPanel;

    public FileColorsConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/tabs/FileColorsConfigurable", "<init>"));
        }
        this.myProject = project2;
    }

    @Nls
    public String getDisplayName() {
        return "File Colors";
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.file-colors";
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new FileColorsConfigurablePanel((FileColorManagerImpl)FileColorManager.getInstance((Project)this.myProject));
        }
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/FileColorsConfigurable", "getId"));
        }
        return string;
    }
}

