/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.WeakList;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SofterReference<T> {
    private volatile Reference<T> myRef;
    private static final WeakList<SofterReference> ourRegistry = new WeakList();

    private static void onLowMemory() {
        for (SofterReference reference : ourRegistry.copyAndClear()) {
            reference.weaken();
        }
    }

    public SofterReference(@NotNull T referent) {
        if (referent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/SofterReference", "<init>"));
        }
        ourRegistry.add((Object)this);
        this.myRef = new SoftReference<T>(referent);
    }

    private void weaken() {
        T o = this.myRef.get();
        if (o != null) {
            this.myRef = new WeakReference<T>(o);
        }
    }

    @Nullable
    public T get() {
        Reference<T> ref = this.myRef;
        T referent = ref.get();
        if (referent != null && ref instanceof WeakReference) {
            ourRegistry.add((Object)this);
            this.myRef = new SoftReference<T>(referent);
        }
        return referent;
    }

    static {
        LowMemoryWatcher.register(() -> SofterReference.onLowMemory(), (Disposable)ApplicationManager.getApplication());
    }
}

