/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.Consumer;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldCompletionProvider
implements TextCompletionProvider {
    protected boolean myCaseInsensitivity;

    protected TextFieldCompletionProvider() {
        this(false);
    }

    protected TextFieldCompletionProvider(boolean caseInsensitivity) {
        this.myCaseInsensitivity = caseInsensitivity;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/TextFieldCompletionProvider", "getPrefix"));
        }
        return this.getPrefix(text2.substring(0, offset));
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/TextFieldCompletionProvider", "applyPrefixMatcher"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/TextFieldCompletionProvider", "applyPrefixMatcher"));
        }
        CompletionResultSet activeResult = result2;
        if (!activeResult.getPrefixMatcher().getPrefix().equals(prefix)) {
            activeResult = activeResult.withPrefixMatcher(prefix);
        }
        if (this.isCaseInsensitivity()) {
            activeResult = activeResult.caseInsensitive();
        }
        CompletionResultSet completionResultSet = activeResult;
        if (completionResultSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "applyPrefixMatcher"));
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/TextFieldCompletionProvider", "fillCompletionVariants"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/TextFieldCompletionProvider", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/TextFieldCompletionProvider", "fillCompletionVariants"));
        }
        this.addCompletionVariants(parameters2.getOriginalFile().getText(), parameters2.getOffset(), prefix, result2);
        result2.stopHere();
    }

    public void apply(@NotNull EditorTextField field, @NotNull String text2) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/TextFieldCompletionProvider", "apply"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/TextFieldCompletionProvider", "apply"));
        }
        Project project2 = field.getProject();
        if (project2 != null) {
            field.setDocument(this.createDocument(project2, text2));
        }
    }

    public void apply(@NotNull EditorTextField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/TextFieldCompletionProvider", "apply"));
        }
        this.apply(field, "");
    }

    private Document createDocument(Project project2, @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/TextFieldCompletionProvider", "createDocument"));
        }
        return LanguageTextField.createDocument(text2, PlainTextLanguage.INSTANCE, project2, new TextCompletionUtil.DocumentWithCompletionCreator(this, true));
    }

    public boolean isCaseInsensitivity() {
        return this.myCaseInsensitivity;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        if (currentTextPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "com/intellij/util/TextFieldCompletionProvider", "getPrefix"));
        }
        String string = currentTextPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "getPrefix"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return null;
    }

    protected abstract void addCompletionVariants(@NotNull String var1, int var2, @NotNull String var3, @NotNull CompletionResultSet var4);

    @NotNull
    public EditorTextField createEditor(Project project2) {
        EditorTextField editorTextField = this.createEditor(project2, true, null);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "createEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField createEditor(Project project2, final boolean shouldHaveBorder, final @Nullable Consumer<Editor> editorConstructionCallback) {
        EditorTextField editorTextField = new EditorTextField(this.createDocument(project2, ""), project2, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType()){

            @Override
            protected boolean shouldHaveBorder() {
                return shouldHaveBorder;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/util/TextFieldCompletionProvider$1", "updateBorder"));
                }
                if (shouldHaveBorder) {
                    super.updateBorder(editor);
                } else {
                    editor.setBorder(null);
                }
            }

            @Override
            protected EditorEx createEditor() {
                EditorEx result2 = super.createEditor();
                if (editorConstructionCallback != null) {
                    editorConstructionCallback.consume((Object)result2);
                }
                return result2;
            }
        };
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "createEditor"));
        }
        return editorTextField;
    }
}

