/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.PsiFileGistImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.gist.VirtualFileGistImpl;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GistManagerImpl
extends GistManager {
    private static final Set<String> ourKnownIds = ContainerUtil.newConcurrentSet();
    private static final String ourPropertyName = "file.gist.reindex.count";
    private final AtomicInteger myReindexCount = new AtomicInteger(PropertiesComponent.getInstance().getInt("file.gist.reindex.count", 0));

    public GistManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/gist/GistManagerImpl$1", "after"));
                }
                if (events.stream().anyMatch(this::shouldDropCache)) {
                    GistManagerImpl.this.invalidateData();
                }
            }

            private boolean shouldDropCache(VFileEvent e) {
                if (!(e instanceof VFilePropertyChangeEvent)) {
                    return false;
                }
                String propertyName = ((VFilePropertyChangeEvent)e).getPropertyName();
                return propertyName.equals("name") || propertyName.equals("encoding");
            }
        });
    }

    @NotNull
    public <Data> VirtualFileGist<Data> newVirtualFileGist(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/util/gist/GistManagerImpl", "newVirtualFileGist"));
        }
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/util/gist/GistManagerImpl", "newVirtualFileGist"));
        }
        if (calcData2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calcData", "com/intellij/util/gist/GistManagerImpl", "newVirtualFileGist"));
        }
        if (!ourKnownIds.add(id)) {
            throw new IllegalArgumentException("Gist '" + id + "' is already registered");
        }
        VirtualFileGistImpl<Data> virtualFileGistImpl = new VirtualFileGistImpl<Data>(id, version, externalizer, calcData2);
        if (virtualFileGistImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/gist/GistManagerImpl", "newVirtualFileGist"));
        }
        return virtualFileGistImpl;
    }

    @NotNull
    public <Data> PsiFileGist<Data> newPsiFileGist(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<PsiFile, Data> calculator) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/util/gist/GistManagerImpl", "newPsiFileGist"));
        }
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/util/gist/GistManagerImpl", "newPsiFileGist"));
        }
        if (calculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "com/intellij/util/gist/GistManagerImpl", "newPsiFileGist"));
        }
        PsiFileGistImpl<Data> psiFileGistImpl = new PsiFileGistImpl<Data>(id, version, externalizer, calculator);
        if (psiFileGistImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/gist/GistManagerImpl", "newPsiFileGist"));
        }
        return psiFileGistImpl;
    }

    int getReindexCount() {
        return this.myReindexCount.get();
    }

    public void invalidateData() {
        PropertiesComponent.getInstance().setValue(ourPropertyName, this.myReindexCount.incrementAndGet(), 0);
    }

    public void resetReindexCount() {
        this.myReindexCount.set(0);
        PropertiesComponent.getInstance().unsetValue(ourPropertyName);
    }
}

