/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ElementProducer;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollectionModelEditor<T, E extends CollectionItemEditor<T>>
implements ElementProducer<T> {
    protected static final Logger LOG = Logger.getInstance(CollectionModelEditor.class);
    protected final E itemEditor;
    protected final ModelHelper helper;

    protected CollectionModelEditor(@NotNull E itemEditor) {
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/CollectionModelEditor", "<init>"));
        }
        this.helper = new ModelHelper();
        this.itemEditor = itemEditor;
    }

    public T createElement() {
        return (T)ReflectionUtil.newInstance(this.itemEditor.getItemClass());
    }

    public boolean canCreateElement() {
        return true;
    }

    @NotNull
    protected abstract List<T> getItems();

    public void reset(@NotNull List<T> originalItems) {
        if (originalItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalItems", "com/intellij/util/ui/CollectionModelEditor", "reset"));
        }
        this.helper.reset(originalItems);
    }

    public final boolean isModified() {
        List<T> items = this.getItems();
        OrderedSet oldItems = this.helper.originalItems;
        if (items.size() != oldItems.size()) {
            return true;
        }
        int size = items.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (items.get(i2).equals(oldItems.get(i2))) continue;
            return true;
        }
        return false;
    }

    public void processModifiedItems(final @NotNull PairProcessor<T, T> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/ui/CollectionModelEditor", "processModifiedItems"));
        }
        this.helper.process(new TObjectObjectProcedure<T, T>(){

            public boolean execute(T newItem, T oldItem) {
                return processor2.process(newItem, oldItem);
            }
        });
    }

    @NotNull
    public final T getMutable(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor", "getMutable"));
        }
        Object t = this.helper.getMutable(item, -1);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CollectionModelEditor", "getMutable"));
        }
        return t;
    }

    protected boolean isEditable(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor", "isEditable"));
        }
        return true;
    }

    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index) {
        if (oldItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/util/ui/CollectionModelEditor", "silentlyReplaceItem"));
        }
        if (newItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/util/ui/CollectionModelEditor", "silentlyReplaceItem"));
        }
        List<T> items = this.getItems();
        items.set(index == -1 ? ContainerUtil.indexOfIdentity(items, oldItem) : index, newItem);
    }

    protected final boolean areSelectedItemsRemovable(@NotNull ListSelectionModel selectionMode) {
        if (selectionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionMode", "com/intellij/util/ui/CollectionModelEditor", "areSelectedItemsRemovable"));
        }
        int minSelectionIndex = selectionMode.getMinSelectionIndex();
        int maxSelectionIndex = selectionMode.getMaxSelectionIndex();
        if (minSelectionIndex < 0 || maxSelectionIndex < 0) {
            return false;
        }
        List<T> items = this.getItems();
        for (int i2 = minSelectionIndex; i2 <= maxSelectionIndex; ++i2) {
            if (!this.itemEditor.isRemovable(items.get(i2))) continue;
            return true;
        }
        return false;
    }

    protected class ModelHelper {
        final OrderedSet<T> originalItems = new OrderedSet(ContainerUtil.identityStrategy());
        private final THashMap<T, T> modifiedToOriginal = ContainerUtil.newIdentityTroveMap();
        private final THashMap<T, T> originalToModified = ContainerUtil.newIdentityTroveMap();

        protected ModelHelper() {
        }

        public void reset(@Nullable List<T> newOriginalItems) {
            if (newOriginalItems != null) {
                this.originalItems.clear();
                this.originalItems.addAll(newOriginalItems);
            }
            this.modifiedToOriginal.clear();
            this.originalToModified.clear();
        }

        public void remove(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "remove"));
            }
            Object original = this.modifiedToOriginal.remove(item);
            if (original != null) {
                this.originalToModified.remove(original);
            }
        }

        public boolean isMutable(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "isMutable"));
            }
            return this.modifiedToOriginal.containsKey(item) || !this.originalItems.contains(item);
        }

        @NotNull
        public T getMutable(@NotNull T item, int index) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
            }
            if (this.isMutable(item) || !CollectionModelEditor.this.isEditable(item)) {
                Object t = item;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
                }
                return t;
            }
            Object mutable = this.originalToModified.get(item);
            if (mutable == null) {
                mutable = CollectionModelEditor.this.itemEditor.clone(item, false);
                this.modifiedToOriginal.put(mutable, item);
                this.originalToModified.put(item, mutable);
                CollectionModelEditor.this.silentlyReplaceItem(item, mutable, index);
            }
            Object object = mutable;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
            }
            return object;
        }

        public boolean hasModifiedItems() {
            return !this.modifiedToOriginal.isEmpty();
        }

        public void process(@NotNull TObjectObjectProcedure<T, T> procedure) {
            if (procedure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "process"));
            }
            this.modifiedToOriginal.forEachEntry(procedure);
        }
    }
}

