/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.TObjectObjectProcedure;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TableModelEditor<T>
extends CollectionModelEditor<T, CollectionItemEditor<T>> {
    private final TableView<T> table;
    private final ToolbarDecorator toolbarDecorator;
    private final MyListTableModel model;

    public TableModelEditor(@NotNull ColumnInfo[] columns, @NotNull CollectionItemEditor<T> itemEditor, @NotNull String emptyText) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        this(Collections.emptyList(), columns, itemEditor, emptyText);
    }

    public TableModelEditor(@NotNull List<T> items, @NotNull ColumnInfo[] columns, @NotNull CollectionItemEditor<T> itemEditor, @NotNull String emptyText) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/util/ui/table/TableModelEditor", "<init>"));
        }
        super(itemEditor);
        this.model = new MyListTableModel(columns, new ArrayList<T>(items));
        this.table = new TableView((ListTableModel)this.model);
        this.table.setDefaultEditor(Enum.class, (TableCellEditor)ComboBoxTableCellEditor.INSTANCE);
        this.table.setStriped(true);
        this.table.setEnableAntialiasing(true);
        this.preferredScrollableViewportHeightInRows(7);
        new TableSpeedSearch((JTable)this.table);
        ColumnInfo firstColumn = columns[0];
        if ((firstColumn.getColumnClass() == Boolean.TYPE || firstColumn.getColumnClass() == Boolean.class) && firstColumn.getName().isEmpty()) {
            TableUtil.setupCheckboxColumn((TableColumn)this.table.getColumnModel().getColumn(0));
        }
        boolean needTableHeader = false;
        for (ColumnInfo column : columns) {
            if (StringUtil.isEmpty((String)column.getName())) continue;
            needTableHeader = true;
            break;
        }
        if (!needTableHeader) {
            this.table.setTableHeader(null);
        }
        this.table.getEmptyText().setText(emptyText);
        MyRemoveAction removeAction = new MyRemoveAction();
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.table, (ElementProducer)this).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction);
        if (itemEditor instanceof DialogItemEditor) {
            this.addDialogActions();
        }
    }

    @NotNull
    public TableModelEditor<T> preferredScrollableViewportHeightInRows(int rows) {
        this.table.setPreferredScrollableViewportSize(new Dimension(200, this.table.getRowHeight() * rows));
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "preferredScrollableViewportHeightInRows"));
        }
        return tableModelEditor;
    }

    private void addDialogActions() {
        this.toolbarDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object item = TableModelEditor.this.table.getSelectedObject();
                if (item != null) {
                    Function mutator;
                    if (TableModelEditor.this.helper.isMutable(item)) {
                        mutator = FunctionUtil.id();
                    } else {
                        int selectedRow = TableModelEditor.this.table.getSelectedRow();
                        mutator = item12 -> TableModelEditor.this.helper.getMutable(item12, selectedRow);
                    }
                    ((DialogItemEditor)TableModelEditor.this.itemEditor).edit(item, mutator, false);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)TableModelEditor.this.table, true));
                }
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Object item = TableModelEditor.this.table.getSelectedObject();
                return item != null && ((DialogItemEditor)TableModelEditor.this.itemEditor).isEditable(item);
            }
        });
        if (((DialogItemEditor)this.itemEditor).isUseDialogToAdd()) {
            this.toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Object item = TableModelEditor.this.createElement();
                    ((DialogItemEditor)TableModelEditor.this.itemEditor).edit(item, item1 -> {
                        TableModelEditor.this.model.addRow(item1);
                        return item1;
                    }, true);
                }
            });
        }
    }

    @NotNull
    public TableModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "disableUpDownActions"));
        }
        return tableModelEditor;
    }

    @NotNull
    public TableModelEditor<T> enabled(boolean value2) {
        this.table.setEnabled(value2);
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "enabled"));
        }
        return tableModelEditor;
    }

    public TableModelEditor<T> modelListener(@NotNull DataChangedListener<T> listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/ui/table/TableModelEditor", "modelListener"));
        }
        this.model.dataChangedListener = listener2;
        this.model.addTableModelListener(listener2);
        return this;
    }

    @NotNull
    public ListTableModel<T> getModel() {
        MyListTableModel myListTableModel = this.model;
        if (myListTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "getModel"));
        }
        return myListTableModel;
    }

    @NotNull
    public static <T> T cloneUsingXmlSerialization(@NotNull T oldItem, @NotNull T newItem) {
        if (oldItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/util/ui/table/TableModelEditor", "cloneUsingXmlSerialization"));
        }
        if (newItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/util/ui/table/TableModelEditor", "cloneUsingXmlSerialization"));
        }
        Element serialized = XmlSerializer.serialize(oldItem, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!JDOMUtil.isEmpty((Element)serialized)) {
            XmlSerializer.deserializeInto(newItem, (Element)serialized);
        }
        T t = newItem;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "cloneUsingXmlSerialization"));
        }
        return t;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/TableModelEditor$4", "actionPerformed"));
                }
                TableUtil.stopEditing((JTable)TableModelEditor.this.table);
                List selectedItems = TableModelEditor.this.table.getSelectedObjects();
                if (selectedItems.isEmpty()) {
                    return;
                }
                for (Object item : selectedItems) {
                    TableModelEditor.this.model.addRow(TableModelEditor.this.itemEditor.clone(item, false));
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)TableModelEditor.this.table, true));
                TableUtil.updateScroller((JTable)TableModelEditor.this.table);
            }
        }).createPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "createComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        List list2 = this.model.items;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "getItems"));
        }
        return list2;
    }

    public void selectItem(final @NotNull T item) {
        Ref ref;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/table/TableModelEditor", "selectItem"));
        }
        this.table.clearSelection();
        if (this.helper.hasModifiedItems()) {
            ref = Ref.create();
            this.helper.process(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T modified, T original) {
                    if (item == original) {
                        ref.set(modified);
                    }
                    return ref.isNull();
                }
            });
        } else {
            ref = null;
        }
        this.table.addSelection(ref == null || ref.isNull() ? item : ref.get());
    }

    @NotNull
    public List<T> apply() {
        if (this.helper.hasModifiedItems()) {
            final ColumnInfo[] columns = this.model.getColumnInfos();
            this.helper.process(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T newItem, @NotNull T oldItem) {
                    if (oldItem == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/util/ui/table/TableModelEditor$6", "execute"));
                    }
                    for (ColumnInfo column : columns) {
                        if (!column.isCellEditable(newItem)) continue;
                        column.setValue(oldItem, column.valueOf(newItem));
                    }
                    if (TableModelEditor.this.itemEditor instanceof DialogItemEditor) {
                        ((DialogItemEditor)TableModelEditor.this.itemEditor).applyEdited(oldItem, newItem);
                    }
                    TableModelEditor.this.model.items.set(ContainerUtil.indexOfIdentity((List)TableModelEditor.this.model.items, newItem), oldItem);
                    return true;
                }
            });
        }
        this.helper.reset(this.model.items);
        List list2 = this.model.items;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/table/TableModelEditor", "apply"));
        }
        return list2;
    }

    @Override
    public void reset(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/table/TableModelEditor", "reset"));
        }
        super.reset(items);
        this.model.setItems(new ArrayList<T>(items));
    }

    private class MyRemoveAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater,
    TableUtil.ItemChecker {
        private MyRemoveAction() {
        }

        public void run(AnActionButton button) {
            if (TableUtil.doRemoveSelectedItems((JTable)TableModelEditor.this.table, (ItemRemovable)TableModelEditor.this.model, (TableUtil.ItemChecker)this)) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)TableModelEditor.this.table, true));
                TableUtil.updateScroller((JTable)TableModelEditor.this.table);
            }
        }

        public boolean isOperationApplyable(@NotNull TableModel ignored, int row) {
            if (ignored == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/util/ui/table/TableModelEditor$MyRemoveAction", "isOperationApplyable"));
            }
            Object item = TableModelEditor.this.model.getItem(row);
            return item != null && TableModelEditor.this.itemEditor.isRemovable(item);
        }

        public boolean isEnabled(AnActionEvent e) {
            return TableModelEditor.this.areSelectedItemsRemovable(TableModelEditor.this.table.getSelectionModel());
        }
    }

    public static abstract class EditableColumnInfo<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        public EditableColumnInfo(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/table/TableModelEditor$EditableColumnInfo", "<init>"));
            }
            super(name2);
        }

        public EditableColumnInfo() {
            super("");
        }

        public boolean isCellEditable(Item item) {
            return true;
        }
    }

    private final class MyListTableModel
    extends ListTableModel<T> {
        private List<T> items;
        private DataChangedListener<T> dataChangedListener;

        public MyListTableModel(@NotNull ColumnInfo[] columns, List<T> items) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/util/ui/table/TableModelEditor$MyListTableModel", "<init>"));
            }
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/table/TableModelEditor$MyListTableModel", "<init>"));
            }
            super(columns, items);
            this.items = items;
        }

        public void setItems(@NotNull List<T> items) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/table/TableModelEditor$MyListTableModel", "setItems"));
            }
            this.items = items;
            super.setItems(items);
        }

        public void removeRow(int index) {
            TableModelEditor.this.helper.remove(this.getItem(index));
            super.removeRow(index);
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (rowIndex < this.getRowCount()) {
                ColumnInfo column = this.getColumnInfos()[columnIndex];
                Object item = this.getItem(rowIndex);
                Object oldValue = column.valueOf(item);
                if (column.getColumnClass() == String.class ? !Comparing.strEqual((String)((String)oldValue), (String)((String)newValue)) : !Comparing.equal((Object)oldValue, (Object)newValue)) {
                    column.setValue(TableModelEditor.this.helper.getMutable(item, rowIndex), newValue);
                    if (this.dataChangedListener != null) {
                        this.dataChangedListener.dataChanged(column, rowIndex);
                    }
                }
            }
        }
    }

    public static interface DialogItemEditor<T>
    extends CollectionItemEditor<T> {
        public void edit(@NotNull T var1, @NotNull Function<T, T> var2, boolean var3);

        public void applyEdited(@NotNull T var1, @NotNull T var2);

        default public boolean isEditable(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/table/TableModelEditor$DialogItemEditor", "isEditable"));
            }
            return true;
        }

        default public boolean isUseDialogToAdd() {
            return false;
        }
    }

    public static abstract class DataChangedListener<T>
    implements TableModelListener {
        public abstract void dataChanged(@NotNull ColumnInfo<T, ?> var1, int var2);

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/TableModelEditor$DataChangedListener", "tableChanged"));
            }
        }
    }
}

