/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ViewUpdateInfoNotification
extends NotificationAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final UpdateInfoTree myTree;

    public ViewUpdateInfoNotification(@NotNull Project project2, @NotNull UpdateInfoTree updateInfoTree, @NotNull String actionName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/ViewUpdateInfoNotification", "<init>"));
        }
        if (updateInfoTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateInfoTree", "com/intellij/vcs/ViewUpdateInfoNotification", "<init>"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/vcs/ViewUpdateInfoNotification", "<init>"));
        }
        super(actionName);
        this.myProject = project2;
        this.myTree = updateInfoTree;
    }

    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/ViewUpdateInfoNotification", "actionPerformed"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/vcs/ViewUpdateInfoNotification", "actionPerformed"));
        }
        ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, this.myTree);
    }

    public static void focusUpdateInfoTree(@NotNull Project project2, @NotNull UpdateInfoTree updateInfoTree) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/ViewUpdateInfoNotification", "focusUpdateInfoTree"));
        }
        if (updateInfoTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateInfoTree", "com/intellij/vcs/ViewUpdateInfoNotification", "focusUpdateInfoTree"));
        }
        ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS).activate(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/ViewUpdateInfoNotification", "lambda$focusUpdateInfoTree$0"));
            }
            if (updateInfoTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateInfoTree", "com/intellij/vcs/ViewUpdateInfoNotification", "lambda$focusUpdateInfoTree$0"));
            }
            ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(project2).getContentManager();
            if (contentManager != null) {
                ContentUtilEx.selectContent(contentManager, (JComponent)((Object)updateInfoTree), true);
            }
        }, true, true);
    }
}

