/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.util.DocumentUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.BodyLimitInspectionOptions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BodyLimitInspection
extends BaseCommitMessageInspection {
    public int RIGHT_MARGIN = 72;

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Limit body line" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/BodyLimitInspection", "getDisplayName"));
        }
        return "Limit body line";
    }

    @Override
    @NotNull
    public ConfigurableUi<Project> createOptionsConfigurable() {
        BodyLimitInspectionOptions bodyLimitInspectionOptions = new BodyLimitInspectionOptions(this);
        if (bodyLimitInspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/BodyLimitInspection", "createOptionsConfigurable"));
        }
        return bodyLimitInspectionOptions;
    }

    @Override
    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/commit/BodyLimitInspection", "checkFile"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/commit/BodyLimitInspection", "checkFile"));
        }
        return (ProblemDescriptor[])IntStream.range(1, document.getLineCount()).mapToObj(line -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/commit/BodyLimitInspection", "lambda$checkFile$0"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection", "lambda$checkFile$0"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/commit/BodyLimitInspection", "lambda$checkFile$0"));
            }
            return BodyLimitInspection.checkRightMargin(file2, document, manager, isOnTheFly, line, this.RIGHT_MARGIN, String.format("Body lines should not exceed %d characters", this.RIGHT_MARGIN), new LocalQuickFix[]{new WrapLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()});
        }).filter(Objects::nonNull).toArray(ProblemDescriptor[]::new);
    }

    @Override
    public boolean canReformat(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BodyLimitInspection", "canReformat"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection", "canReformat"));
        }
        return this.hasProblems(project2, document);
    }

    @Override
    public void reformat(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BodyLimitInspection", "reformat"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection", "reformat"));
        }
        new WrapLineQuickFix().doApplyFix(project2, document, null);
    }

    protected class WrapLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected WrapLineQuickFix() {
            super("Wrap line");
        }

        @Override
        public void doApplyFix(@NotNull Project project2, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "doApplyFix"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "doApplyFix"));
            }
            Editor editor = CommitMessage.getEditor(document);
            if (editor != null) {
                TextRange range;
                TextRange textRange = range = descriptor != null && descriptor.getLineNumber() >= 0 ? DocumentUtil.getLineTextRange(document, descriptor.getLineNumber()) : this.getBodyRange(document);
                if (!range.isEmpty()) {
                    this.wrapLines(project2, editor, document, BodyLimitInspection.this.RIGHT_MARGIN, range);
                }
            }
        }

        @NotNull
        private TextRange getBodyRange(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "getBodyRange"));
            }
            TextRange textRange = document.getLineCount() > 1 ? TextRange.create((int)document.getLineStartOffset(1), (int)document.getTextLength()) : TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "getBodyRange"));
            }
            return textRange;
        }

        private void wrapLines(@NotNull Project project2, @NotNull Editor editor, @NotNull Document document, final int rightMargin, @NotNull TextRange range) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "wrapLines"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "wrapLines"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "wrapLines"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix", "wrapLines"));
            }
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(new CodeStyleSettings(false){

                public int getRightMargin(@Nullable Language language) {
                    return rightMargin;
                }
            }, null);
            List<TextRange> enabledRanges = Collections.singletonList(TextRange.create((int)0, (int)document.getTextLength()));
            codeFormatter.doWrapLongLinesIfNecessary(editor, project2, document, range.getStartOffset(), range.getEndOffset(), enabledRanges);
        }
    }
}

