/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CommitMessageSpellCheckingInspection
extends BaseCommitMessageInspection {
    private static final Logger LOG = Logger.getInstance(CommitMessageSpellCheckingInspection.class);
    private static final AtomicNullableLazyValue<LocalInspectionTool> ourSpellCheckingInspection = AtomicNullableLazyValue.createValue(() -> {
        LocalInspectionTool result2 = null;
        List<InspectionToolWrapper> tools = InspectionToolRegistrar.getInstance().createTools();
        InspectionToolWrapper spellCheckingWrapper = (InspectionToolWrapper)ContainerUtil.find(tools, wrapper -> wrapper.getShortName().equals("SpellCheckingInspection"));
        if (spellCheckingWrapper == null) {
            LOG.error("Could not find default spell checking inspection");
        } else if (!(spellCheckingWrapper instanceof LocalInspectionToolWrapper)) {
            LOG.error("Found spell checking wrapper is not local " + spellCheckingWrapper);
        } else {
            result2 = (LocalInspectionTool)((LocalInspectionToolWrapper)spellCheckingWrapper).getTool();
        }
        return result2;
    });

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/vcs/commit/CommitMessageSpellCheckingInspection", "buildVisitor"));
        }
        LocalInspectionTool tool = (LocalInspectionTool)ourSpellCheckingInspection.getValue();
        PsiElementVisitor psiElementVisitor = tool != null ? tool.buildVisitor(holder, isOnTheFly) : super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/CommitMessageSpellCheckingInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Spelling" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/CommitMessageSpellCheckingInspection", "getDisplayName"));
        }
        return "Spelling";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = (HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.WARNING);
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/CommitMessageSpellCheckingInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

