/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCommitMessageAction
extends DumbAwareAction {
    public static final String NAME = "Reformat commit message";

    public ReformatCommitMessageAction() {
        super(NAME);
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/commit/ReformatCommitMessageAction", "update"));
        }
        Project project2 = e.getProject();
        Document document = ReformatCommitMessageAction.getCommitMessage(e);
        e.getPresentation().setEnabled(project2 != null && document != null && ReformatCommitMessageAction.getEnabledInspections(project2).anyMatch(inspection -> inspection.canReformat(project2, document)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/commit/ReformatCommitMessageAction", "actionPerformed"));
        }
        Project project2 = (Project)ObjectUtils.notNull((Object)e.getProject());
        Document document = (Document)ObjectUtils.notNull((Object)ReformatCommitMessageAction.getCommitMessage(e));
        CommandProcessor.getInstance().executeCommand(project2, () -> WriteAction.run(() -> ReformatCommitMessageAction.reformat(project2, document)), NAME, null);
    }

    public static void reformat(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/ReformatCommitMessageAction", "reformat"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/ReformatCommitMessageAction", "reformat"));
        }
        List<BaseCommitMessageInspection> inspections = ReformatCommitMessageAction.getEnabledInspections(project2).collect(Collectors.toList());
        inspections.forEach(inspection -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/ReformatCommitMessageAction", "lambda$reformat$3"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/ReformatCommitMessageAction", "lambda$reformat$3"));
            }
            inspection.reformat(project2, document);
        });
    }

    @Nullable
    private static Document getCommitMessage(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/commit/ReformatCommitMessageAction", "getCommitMessage"));
        }
        CommitMessage commitMessage = (CommitMessage)ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL), CommitMessage.class);
        Editor editor = commitMessage != null ? commitMessage.getEditorField().getEditor() : null;
        return editor != null ? editor.getDocument() : null;
    }

    @NotNull
    private static Stream<BaseCommitMessageInspection> getEnabledInspections(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/ReformatCommitMessageAction", "getEnabledInspections"));
        }
        Stream<BaseCommitMessageInspection> stream = CommitMessageInspectionProfile.getInstance(project2).getAllEnabledInspectionTools(project2).stream().map(Tools::getTool).map(InspectionToolWrapper::getTool).filter(BaseCommitMessageInspection.class::isInstance).map(BaseCommitMessageInspection.class::cast);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/ReformatCommitMessageAction", "getEnabledInspections"));
        }
        return stream;
    }
}

