/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import com.intellij.vcs.log.util.StopWatch;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<Task> myTaskExecutor;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<Runnable> myLoadingFinishedListeners;
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache;
    @NotNull
    private Map<VirtualFile, ContainedInBranchCondition> myConditions;
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/data/ContainingBranchesGetter", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/data/ContainingBranchesGetter", "<init>"));
        }
        this.myLoadingFinishedListeners = ContainerUtil.newArrayList();
        this.myCache = ContainingBranchesGetter.createCache();
        this.myConditions = ContainerUtil.newHashMap();
        this.myLogData = logData;
        this.myTaskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, task -> {
            List<String> branches = task.getContainingBranches(this.myLogData);
            ApplicationManager.getApplication().invokeLater(() -> {
                ((Task)task).cache.put((Object)new CommitId(((Task)task).hash, ((Task)task).root), (Object)branches);
                this.notifyListeners();
            });
        });
        this.myLogData.addDataPackChangeListener(dataPack -> {
            Collection<VcsRef> currentBranches = dataPack.getRefsModel().getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        });
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        Map<VirtualFile, ContainedInBranchCondition> conditions = this.myConditions;
        this.myConditions = ContainerUtil.newHashMap();
        for (ContainedInBranchCondition c : conditions.values()) {
            c.dispose();
        }
        ApplicationManager.getApplication().invokeLater(this::notifyListeners);
    }

    public void addTaskCompletedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/ContainingBranchesGetter", "addTaskCompletedListener"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeTaskCompletedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/ContainingBranchesGetter", "removeTaskCompletedListener"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.myLoadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "requestContainingBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "requestContainingBranches"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root, hash);
        if (refs == null) {
            DataPack dataPack = this.myLogData.getDataPack();
            this.myTaskExecutor.queue(new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()));
        }
        return refs;
    }

    @Nullable
    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesFromCache"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesFromCache"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @Nullable
    public List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesQuickly"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesQuickly"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        CommitId commitId = new CommitId(hash, root);
        List<String> branches = (List<String>)this.myCache.get((Object)commitId);
        if (branches == null) {
            int nodeId;
            int index = this.myLogData.getCommitIndex(hash, root);
            PermanentGraph<Integer> pg = this.myLogData.getDataPack().getPermanentGraph();
            if (pg instanceof PermanentGraphInfo && (branches = (nodeId = ((PermanentGraphInfo)pg).getPermanentCommitsInfo().getNodeId(index)) < 10000 && ContainingBranchesGetter.canUseGraphForComputation(this.myLogData.getLogProvider(root)) ? this.getContainingBranchesSynchronously(root, hash) : (List)BackgroundTaskUtil.tryComputeFast(indicator -> {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "lambda$getContainingBranchesQuickly$3"));
                }
                if (hash == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "lambda$getContainingBranchesQuickly$3"));
                }
                return this.getContainingBranchesSynchronously(root, hash);
            }, 100L)) != null) {
                this.myCache.put((Object)commitId, branches);
            }
        }
        return branches;
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull String branchName, @NotNull VirtualFile root) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainedInBranchCondition"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainedInBranchCondition"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        DataPack dataPack = this.myLogData.getDataPack();
        if (dataPack == DataPack.EMPTY) {
            Condition condition2 = Conditions.alwaysFalse();
            if (condition2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainedInBranchCondition"));
            }
            return condition2;
        }
        PermanentGraph<Integer> graph = dataPack.getPermanentGraph();
        RefsModel refs = dataPack.getRefsModel();
        ContainedInBranchCondition condition3 = this.myConditions.get(root);
        if (condition3 == null || !condition3.getBranch().equals(branchName)) {
            VcsRef branchRef = (VcsRef)ContainerUtil.find((Iterable)refs.getBranches(), vcsRef -> {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "lambda$getContainedInBranchCondition$4"));
                }
                if (branchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/vcs/log/data/ContainingBranchesGetter", "lambda$getContainedInBranchCondition$4"));
                }
                return vcsRef.getRoot().equals(root) && vcsRef.getName().equals(branchName);
            });
            if (branchRef == null) {
                Condition condition4 = Conditions.alwaysFalse();
                if (condition4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainedInBranchCondition"));
                }
                return condition4;
            }
            condition3 = new ContainedInBranchCondition((Condition<Integer>)graph.getContainedInBranchCondition(Collections.singleton(this.myLogData.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot()))), branchName);
            this.myConditions.put(root, condition3);
        }
        ContainedInBranchCondition containedInBranchCondition = condition3;
        if (containedInBranchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainedInBranchCondition"));
        }
        return containedInBranchCondition;
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        SLRUMap sLRUMap = new SLRUMap(1000, 1000);
        if (sLRUMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "createCache"));
        }
        return sLRUMap;
    }

    @NotNull
    public List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesSynchronously"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesSynchronously"));
        }
        List<String> list2 = this.doGetContainingBranches(this.myLogData.getDataPack(), root, hash);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranchesSynchronously"));
        }
        return list2;
    }

    @NotNull
    private List<String> doGetContainingBranches(@NotNull DataPack dataPack, @NotNull VirtualFile root, @NotNull Hash hash) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/ContainingBranchesGetter", "doGetContainingBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "doGetContainingBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "doGetContainingBranches"));
        }
        List<String> list2 = new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()).getContainingBranches(this.myLogData);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "doGetContainingBranches"));
        }
        return list2;
    }

    private static boolean canUseGraphForComputation(@NotNull VcsLogProvider logProvider) {
        if (logProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProvider", "com/intellij/vcs/log/data/ContainingBranchesGetter", "canUseGraphForComputation"));
        }
        return (Boolean)VcsLogProperties.get((VcsLogProvider)logProvider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.LIGHTWEIGHT_BRANCHES);
    }

    private class ContainedInBranchCondition
    implements Condition<CommitId> {
        @NotNull
        private final Condition<Integer> myCondition;
        @NotNull
        private final String myBranch;
        private volatile boolean isDisposed;

        public ContainedInBranchCondition(@NotNull Condition<Integer> condition2, String branch) {
            if (condition2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/ContainingBranchesGetter$ContainedInBranchCondition", "<init>"));
            }
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/intellij/vcs/log/data/ContainingBranchesGetter$ContainedInBranchCondition", "<init>"));
            }
            this.isDisposed = false;
            this.myCondition = condition2;
            this.myBranch = branch;
        }

        @NotNull
        public String getBranch() {
            String string = this.myBranch;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter$ContainedInBranchCondition", "getBranch"));
            }
            return string;
        }

        public boolean value(CommitId commitId) {
            if (this.isDisposed) {
                return false;
            }
            return this.myCondition.value((Object)ContainingBranchesGetter.this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot()));
        }

        public void dispose() {
            this.isDisposed = true;
        }
    }

    private static class Task {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final Hash hash;
        @NotNull
        private final SLRUMap<CommitId, List<String>> cache;
        @NotNull
        private final RefsModel refs;
        @NotNull
        private final PermanentGraph<Integer> graph;

        public Task(@NotNull VirtualFile root, @NotNull Hash hash, @NotNull SLRUMap<CommitId, List<String>> cache, @NotNull PermanentGraph<Integer> graph, @NotNull RefsModel refs) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "<init>"));
            }
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "<init>"));
            }
            if (cache == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "<init>"));
            }
            if (graph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "<init>"));
            }
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "<init>"));
            }
            this.root = root;
            this.hash = hash;
            this.cache = cache;
            this.graph = graph;
            this.refs = refs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public List<String> getContainingBranches(@NotNull VcsLogData logData) {
            ArrayList<String> arrayList;
            StopWatch sw;
            block14: {
                ArrayList<String> arrayList2;
                block13: {
                    if (logData == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "getContainingBranches"));
                    }
                    sw = StopWatch.start("get containing branches");
                    try {
                        VcsLogProvider provider = logData.getLogProvider(this.root);
                        if (ContainingBranchesGetter.canUseGraphForComputation(provider)) {
                            Set branchesIndexes = this.graph.getContainingBranches((Object)logData.getCommitIndex(this.hash, this.root));
                            Collection branchesRefs = new HashSet();
                            for (Integer index : branchesIndexes) {
                                this.refs.refsToCommit(index).stream().filter(ref -> ref.getType().isBranch()).forEach(branchesRefs::add);
                            }
                            branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
                            ArrayList<String> branchesList = new ArrayList<String>();
                            for (VcsRef ref2 : branchesRefs) {
                                branchesList.add(ref2.getName());
                            }
                            ArrayList<String> arrayList3 = branchesList;
                            arrayList2 = arrayList3;
                            break block13;
                        }
                        ArrayList<String> branches = new ArrayList<String>(provider.getContainingBranches(this.root, this.hash));
                        Collections.sort(branches);
                        ArrayList<String> arrayList4 = branches;
                        arrayList = arrayList4;
                        break block14;
                    }
                    catch (VcsException e) {
                        LOG.warn((Throwable)e);
                        List<String> list2 = Collections.emptyList();
                        List<String> list3 = list2;
                        if (list3 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "getContainingBranches"));
                        }
                        return list3;
                    }
                }
                if (arrayList2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "getContainingBranches"));
                }
                return arrayList2;
            }
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter$Task", "getContainingBranches"));
            }
            return arrayList;
            finally {
                sw.report();
            }
        }
    }
}

