/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleTaskController<Request, Result> {
    private static final Logger LOG = Logger.getInstance(SingleTaskController.class);
    @NotNull
    private final Consumer<Result> myResultHandler;
    @NotNull
    private final Object LOCK;
    @NotNull
    private List<Request> myAwaitingRequests;
    private boolean myActive;

    public SingleTaskController(@NotNull Consumer<Result> handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/vcs/log/data/SingleTaskController", "<init>"));
        }
        this.LOCK = new Object();
        this.myResultHandler = handler2;
        this.myAwaitingRequests = ContainerUtil.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void request(@NotNull Request requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/vcs/log/data/SingleTaskController", "request"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myAwaitingRequests.add(requests);
            LOG.debug("Added requests: " + requests);
            if (!this.myActive) {
                this.startNewBackgroundTask();
                LOG.debug("Started a new bg task");
                this.myActive = true;
            }
        }
    }

    protected abstract void startNewBackgroundTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<Request> popRequests() {
        Object object = this.LOCK;
        // MONITORENTER : object
        List<Request> requests = this.myAwaitingRequests;
        this.myAwaitingRequests = ContainerUtil.newArrayList();
        LOG.debug("Popped requests: " + requests);
        List<Request> list2 = requests;
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/SingleTaskController", "popRequests"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskCompleted(@Nullable Result result2) {
        if (result2 != null) {
            this.myResultHandler.consume(result2);
            LOG.debug("Handled result: " + result2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                this.myActive = false;
                LOG.debug("No more requests");
            } else {
                this.startNewBackgroundTask();
                LOG.debug("Restarted a bg task");
            }
        }
    }
}

