/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeData>> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull String logId, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "<init>"));
        }
        super(logId, PATHS, VcsLogPersistentIndex.getVersion(), new PathsIndexer(VcsLogPathsIndex.createPathsEnumerator(logId), roots), new ChangeDataListKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> {
            if (fatalErrorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$new$0"));
            }
            fatalErrorHandler.consume(this, (Exception)e);
        }));
    }

    @NotNull
    private static PersistentEnumeratorBase<String> createPathsEnumerator(@NotNull String logId) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "createPathsEnumerator"));
        }
        File storageFile = PersistentUtil.getStorageFile("index", INDEX_PATHS_IDS, logId, VcsLogPersistentIndex.getVersion());
        PersistentBTreeEnumerator persistentBTreeEnumerator = new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)(SystemInfo.isFileSystemCaseSensitive ? EnumeratorStringDescriptor.INSTANCE : new ToLowerCaseStringDescriptor()), Page.PAGE_SIZE, null, VcsLogPersistentIndex.getVersion());
        if (persistentBTreeEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "createPathsEnumerator"));
        }
        return persistentBTreeEnumerator;
    }

    @Nullable
    public String getPath(int pathId) {
        try {
            return (String)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId);
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @NotNull
    public TIntHashSet getCommitsForPaths(@NotNull Collection<FilePath> paths) throws IOException, StorageException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PATHS, "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getCommitsForPaths"));
        }
        Set<Integer> allPathIds = this.getPathIds(paths);
        TIntHashSet result2 = new TIntHashSet();
        Set<Integer> renames = allPathIds;
        while (!renames.isEmpty()) {
            renames = this.addCommitsAndGetRenames(renames, allPathIds, result2);
            allPathIds.addAll(renames);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getCommitsForPaths"));
        }
        return tIntHashSet;
    }

    @NotNull
    private Set<Integer> getPathIds(@NotNull Collection<FilePath> paths) throws IOException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PATHS, "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getPathIds"));
        }
        HashSet allPathIds = ContainerUtil.newHashSet();
        for (FilePath path : paths) {
            allPathIds.add(this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath()));
        }
        HashSet hashSet = allPathIds;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getPathIds"));
        }
        return hashSet;
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) throws IOException, StorageException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getFileNames"));
        }
        int startId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath());
        HashSet startIds = ContainerUtil.newHashSet();
        startIds.add(startId);
        HashSet allIds = ContainerUtil.newHashSet((Iterable)startIds);
        HashSet newIds = ContainerUtil.newHashSet();
        HashSet resultIds = ContainerUtil.newHashSet();
        block0: while (!startIds.isEmpty()) {
            Iterator iterator = startIds.iterator();
            while (iterator.hasNext()) {
                int currentPathId = (Integer)iterator.next();
                boolean foundCommit = !this.iterateCommitIdsAndValues(currentPathId, (T changesList, Integer commitId) -> {
                    Set<Integer> otherNames = VcsLogPathsIndex.getOtherNames(changesList);
                    if (commitId == commit) {
                        resultIds.add(currentPathId);
                        resultIds.addAll(otherNames);
                        return false;
                    }
                    for (Integer otherPath : otherNames) {
                        if (allIds.contains(otherPath)) continue;
                        newIds.add(otherPath);
                    }
                    return true;
                });
                if (!foundCommit) continue;
                break block0;
            }
            startIds = ContainerUtil.newHashSet((Iterable)newIds);
            allIds.addAll(startIds);
            newIds.clear();
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (Integer id : resultIds) {
            result2.add(VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(id.intValue()))));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getFileNames"));
        }
        return hashSet;
    }

    public void iterateCommits(@NotNull FilePath path, @NotNull ObjIntConsumer<Pair<FilePath, List<ChangeData>>> consumer) throws IOException, StorageException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "iterateCommits"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "iterateCommits"));
        }
        HashSet startIds = this.getPathIds(Collections.singleton(path));
        HashSet allIds = ContainerUtil.newHashSet(startIds);
        HashSet newIds = ContainerUtil.newHashSet();
        while (!startIds.isEmpty()) {
            for (int currentPathId : startIds) {
                FilePath currentPath = VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(currentPathId)));
                this.iterateCommitIdsAndValues(currentPathId, (T changesList, int commitId) -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$iterateCommits$2"));
                    }
                    Set<Integer> otherNames = VcsLogPathsIndex.getOtherNames(changesList);
                    for (int renamed : otherNames) {
                        if (allIds.contains(renamed)) continue;
                        newIds.add(renamed);
                    }
                    consumer.accept(Pair.create((Object)currentPath, (Object)changesList), commitId);
                });
            }
            startIds = ContainerUtil.newHashSet((Iterable)newIds);
            allIds.addAll(startIds);
            newIds.clear();
        }
    }

    @NotNull
    public Set<Integer> addCommitsAndGetRenames(@NotNull Set<Integer> newPathIds, @NotNull Set<Integer> allPathIds, @NotNull TIntHashSet commits) throws StorageException {
        if (newPathIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        if (allPathIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        HashSet renames = ContainerUtil.newHashSet();
        for (Integer key2 : newPathIds) {
            this.iterateCommitIdsAndValues((int)key2, (T value2, int commit) -> {
                if (commits == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$addCommitsAndGetRenames$4"));
                }
                if (allPathIds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$addCommitsAndGetRenames$4"));
                }
                commits.add(commit);
                renames.addAll(ContainerUtil.filter(VcsLogPathsIndex.getOtherNames(value2), r -> {
                    if (allPathIds == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPathIds", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "lambda$null$3"));
                    }
                    return !allPathIds.contains(r);
                }));
            });
        }
        HashSet hashSet = renames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "addCommitsAndGetRenames"));
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private static Set<Integer> getOtherNames(@NotNull List<ChangeData> changesList) {
        if (changesList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesList", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getOtherNames"));
        }
        HashSet otherNames = ContainerUtil.newHashSet();
        for (ChangeData data : changesList) {
            if (data == null || data.otherPath == -1) continue;
            otherNames.add(data.otherPath);
        }
        HashSet hashSet = otherNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex", "getOtherNames"));
        }
        return hashSet;
    }

    private static class ToLowerCaseStringDescriptor
    implements KeyDescriptor<String> {
        private ToLowerCaseStringDescriptor() {
        }

        public int getHashCode(String value2) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.computeHashCode(value2);
        }

        public boolean isEqual(String val1, String val2) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.equals(val1, val2);
        }

        public void save(@NotNull DataOutput out, String value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ToLowerCaseStringDescriptor", "save"));
            }
            IOUtil.writeUTF((DataOutput)out, (String)value2.toLowerCase());
        }

        public String read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ToLowerCaseStringDescriptor", "read"));
            }
            return IOUtil.readUTF((DataInput)in);
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        RENAMED_FROM(1),
        RENAMED_TO(2);

        public final byte id;

        private ChangeKind(byte id) {
            this.id = id;
        }

        public static ChangeKind getKind(byte id) {
            switch (id) {
                case 0: {
                    return MODIFIED;
                }
                case 1: {
                    return RENAMED_FROM;
                }
                case 2: {
                    return RENAMED_TO;
                }
            }
            throw new IllegalArgumentException("No change kind with id " + id);
        }
    }

    public static class ChangeData {
        @NotNull
        public final ChangeKind kind;
        public final int otherPath;

        public ChangeData(@NotNull ChangeKind kind2, int otherPath) {
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeData", "<init>"));
            }
            this.kind = kind2;
            this.otherPath = otherPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeData data = (ChangeData)o;
            return this.otherPath == data.otherPath && this.kind == data.kind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.otherPath});
        }
    }

    private static class ChangeDataListKeyDescriptor
    implements DataExternalizer<List<ChangeData>> {
        private ChangeDataListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeData> value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeDataListKeyDescriptor", "save"));
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.size());
            for (ChangeData data : value2) {
                if (data == null) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                out.writeByte(data.kind.id);
                if (data.kind != ChangeKind.RENAMED_TO && data.kind != ChangeKind.RENAMED_FROM) continue;
                out.writeInt(data.otherPath);
            }
        }

        public List<ChangeData> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeDataListKeyDescriptor", "read"));
            }
            List value2 = ContainerUtil.newSmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i2 = 0; i2 < size; ++i2) {
                if (in.readBoolean()) {
                    ChangeKind kind2 = ChangeKind.getKind(in.readByte());
                    int otherPath = kind2 == ChangeKind.RENAMED_TO || kind2 == ChangeKind.RENAMED_FROM ? in.readInt() : -1;
                    value2.add(new ChangeData(kind2, otherPath));
                    continue;
                }
                value2.add(null);
            }
            return value2;
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, List<ChangeData>, VcsFullCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<String> myPathsEnumerator;
        @NotNull
        private final Set<String> myRoots;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        private PathsIndexer(@NotNull PersistentEnumeratorBase<String> enumerator, @NotNull Set<VirtualFile> roots) {
            if (enumerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerator", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "<init>"));
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myPathsEnumerator = enumerator;
            this.myRoots = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
            for (VirtualFile root : roots) {
                this.myRoots.add(root.getPath());
            }
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorConsumer", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "setFatalErrorConsumer"));
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeData>> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "map"));
            }
            THashMap result2 = new THashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            int parent = 0;
            while (parent < parentsCount) {
                Collection<Object> moves;
                Collection<Object> changedPaths;
                if (inputData instanceof VcsIndexableDetails) {
                    changedPaths = ((VcsIndexableDetails)inputData).getModifiedPaths(parent);
                    moves = ((VcsIndexableDetails)inputData).getRenamedPaths(parent);
                } else {
                    moves = ContainerUtil.newHashSet();
                    changedPaths = ContainerUtil.newHashSet();
                    for (Change change : inputData.getChanges()) {
                        if (change.getAfterRevision() != null) {
                            changedPaths.add(change.getAfterRevision().getFile().getPath());
                        }
                        if (change.getBeforeRevision() != null) {
                            changedPaths.add(change.getBeforeRevision().getFile().getPath());
                        }
                        if (!change.getType().equals((Object)Change.Type.MOVED)) continue;
                        moves.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
                    }
                }
                int finalParent = parent++;
                moves.forEach(move -> {
                    changedPaths.add(PathUtil.getParentPath((String)((String)move.first)));
                    changedPaths.add(PathUtil.getParentPath((String)((String)move.second)));
                });
                this.getParentPaths((Collection<String>)changedPaths).forEach(arg_0 -> this.lambda$map$1((Map)result2, finalParent, parentsCount, arg_0));
                moves.forEach(arg_0 -> this.lambda$map$2((Map)result2, finalParent, parentsCount, arg_0));
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "map"));
            }
            return tHashMap;
        }

        private void addChangeToResult(@NotNull Map<Integer, List<ChangeData>> commitChangesMap, int parent, int parentsCount, @NotNull String afterPath, @Nullable String beforePath) throws IOException {
            if (commitChangesMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitChangesMap", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "addChangeToResult"));
            }
            if (afterPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterPath", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "addChangeToResult"));
            }
            int afterId = this.myPathsEnumerator.enumerate((Object)afterPath);
            List<ChangeData> changeDataList = PathsIndexer.getOrCreateChangeDataListForPath(commitChangesMap, afterId, parentsCount);
            if (beforePath == null) {
                PathsIndexer.addChange(changeDataList, parent, new ChangeData(ChangeKind.MODIFIED, -1));
            } else {
                int beforeId = this.myPathsEnumerator.enumerate((Object)beforePath);
                if (beforeId == afterId && !SystemInfo.isFileSystemCaseSensitive) {
                    PathsIndexer.addChange(changeDataList, parent, new ChangeData(ChangeKind.MODIFIED, -1));
                } else {
                    PathsIndexer.addChange(changeDataList, parent, new ChangeData(ChangeKind.RENAMED_TO, beforeId));
                    List<ChangeData> beforeChangeDataList = PathsIndexer.getOrCreateChangeDataListForPath(commitChangesMap, beforeId, parentsCount);
                    PathsIndexer.addChange(beforeChangeDataList, parent, new ChangeData(ChangeKind.RENAMED_FROM, afterId));
                }
            }
        }

        @NotNull
        private static List<ChangeData> getOrCreateChangeDataListForPath(@NotNull Map<Integer, List<ChangeData>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            if (pathIdToChangeDataListsMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathIdToChangeDataListsMap", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getOrCreateChangeDataListForPath"));
            }
            List changeDataList = pathIdToChangeDataListsMap.get(pathId);
            if (changeDataList == null) {
                changeDataList = ContainerUtil.newSmartList();
                for (int i2 = 0; i2 < parentsCount; ++i2) {
                    changeDataList.add(null);
                }
                pathIdToChangeDataListsMap.put(pathId, changeDataList);
            }
            List list2 = changeDataList;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getOrCreateChangeDataListForPath"));
            }
            return list2;
        }

        private static void addChange(@NotNull List<ChangeData> changeDataList, int parentIndex, @NotNull ChangeData change) {
            if (changeDataList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeDataList", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "addChange"));
            }
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "addChange"));
            }
            ChangeData existingChange = changeDataList.get(parentIndex);
            if (existingChange == null || existingChange.kind != ChangeKind.RENAMED_FROM && existingChange.kind != ChangeKind.RENAMED_TO) {
                changeDataList.set(parentIndex, change);
            }
        }

        @NotNull
        private Collection<String> getParentPaths(@NotNull Collection<String> paths) {
            if (paths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VcsLogPathsIndex.PATHS, "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getParentPaths"));
            }
            HashSet result2 = ContainerUtil.newHashSet();
            block0: for (String path : paths) {
                while (!path.isEmpty() && !result2.contains(path)) {
                    result2.add(path);
                    if (this.myRoots.contains(path)) continue block0;
                    path = PathUtil.getParentPath((String)path);
                }
            }
            HashSet hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getParentPaths"));
            }
            return hashSet;
        }

        @NotNull
        public PersistentEnumeratorBase<String> getPathsEnumerator() {
            PersistentEnumeratorBase<String> persistentEnumeratorBase = this.myPathsEnumerator;
            if (persistentEnumeratorBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer", "getPathsEnumerator"));
            }
            return persistentEnumeratorBase;
        }

        private /* synthetic */ void lambda$map$2(Map result2, int finalParent, int parentsCount, Couple renamedPaths) {
            try {
                this.addChangeToResult(result2, finalParent, parentsCount, (String)renamedPaths.second, (String)renamedPaths.first);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }

        private /* synthetic */ void lambda$map$1(Map result2, int finalParent, int parentsCount, String changedPath) {
            try {
                this.addChangeToResult(result2, finalParent, parentsCount, changedPath, null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }
    }
}

