/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterController
extends CascadeController {
    @NotNull
    private CollapsedGraph myCollapsedGraph;
    @Nullable
    private final Set<Integer> myIdsOfVisibleBranches;

    public BranchFilterController(@NotNull CascadeController delegateLinearGraphController, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @Nullable Set<Integer> idsOfVisibleBranches) {
        if (delegateLinearGraphController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateLinearGraphController", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "<init>"));
        }
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "<init>"));
        }
        super(delegateLinearGraphController, permanentGraphInfo);
        this.myIdsOfVisibleBranches = idsOfVisibleBranches;
        this.myCollapsedGraph = this.updateCollapsedGraph();
    }

    @NotNull
    private CollapsedGraph updateCollapsedGraph() {
        UnsignedBitSet initVisibility = ReachableNodes.getReachableNodes(this.myPermanentGraphInfo.getLinearGraph(), this.myIdsOfVisibleBranches);
        CollapsedGraph collapsedGraph = CollapsedGraph.newInstance(this.getDelegateController().getCompiledGraph(), initVisibility);
        if (collapsedGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "updateCollapsedGraph"));
        }
        return collapsedGraph;
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnswer", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "delegateGraphChanged"));
        }
        if (delegateAnswer.getGraphChanges() != null) {
            this.myCollapsedGraph = this.updateCollapsedGraph();
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = delegateAnswer;
        if (linearGraphAnswer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "delegateGraphChanged"));
        }
        return linearGraphAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "performAction"));
        }
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.myCollapsedGraph.getCompiledGraph();
        if (linearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "getCompiledGraph"));
        }
        return linearGraph;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/collapsing/BranchFilterController", "convertToDelegate"));
        }
        return CollapsedController.convertToDelegate(graphElement, this.myCollapsedGraph);
    }
}

