/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PrintElementManagerImpl;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleGraphImpl<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    private final LinearGraphController myGraphController;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraph;
    @NotNull
    private final GraphColorManager<CommitId> myColorManager;
    private PrintElementManagerImpl myPrintElementManager;
    private PrintElementGeneratorImpl myPrintElementGenerator;
    private boolean myShowLongEdges;

    public VisibleGraphImpl(@NotNull LinearGraphController graphController, @NotNull PermanentGraphInfo<CommitId> permanentGraph, @NotNull GraphColorManager<CommitId> colorManager) {
        if (graphController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphController", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "<init>"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "<init>"));
        }
        this.myShowLongEdges = false;
        this.myGraphController = graphController;
        this.myPermanentGraph = permanentGraph;
        this.myColorManager = colorManager;
        this.updatePrintElementGenerator();
    }

    public int getVisibleCommitCount() {
        return this.myGraphController.getCompiledGraph().nodesCount();
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(int visibleRow) {
        int nodeId = this.getNodeId(visibleRow);
        assert (nodeId >= 0);
        RowInfoImpl rowInfoImpl = new RowInfoImpl(nodeId, visibleRow);
        if (rowInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getRowInfo"));
        }
        return rowInfoImpl;
    }

    public int getNodeId(int visibleRow) {
        return this.myGraphController.getCompiledGraph().getNodeId(visibleRow);
    }

    @Nullable
    public Integer getVisibleRowIndex(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getVisibleRowIndex"));
        }
        int nodeId = this.myPermanentGraph.getPermanentCommitsInfo().getNodeId(commitId);
        return this.myGraphController.getCompiledGraph().getNodeIndex(nodeId);
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        ActionControllerImpl actionControllerImpl = new ActionControllerImpl();
        if (actionControllerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getActionController"));
        }
        return actionControllerImpl;
    }

    private void updatePrintElementGenerator() {
        this.myPrintElementManager = new PrintElementManagerImpl(this.myGraphController.getCompiledGraph(), this.myPermanentGraph, this.myColorManager);
        this.myPrintElementGenerator = new PrintElementGeneratorImpl(this.myGraphController.getCompiledGraph(), this.myPrintElementManager, this.myShowLongEdges);
    }

    @NotNull
    public SimpleGraphInfo<CommitId> buildSimpleGraphInfo() {
        SimpleGraphInfo<CommitId> simpleGraphInfo = SimpleGraphInfo.build(this.myGraphController.getCompiledGraph(), this.myPermanentGraph.getPermanentGraphLayout(), this.myPermanentGraph.getPermanentCommitsInfo(), this.myPermanentGraph.getLinearGraph().nodesCount(), this.myPermanentGraph.getBranchNodeIds());
        if (simpleGraphInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "buildSimpleGraphInfo"));
        }
        return simpleGraphInfo;
    }

    public int getRecommendedWidth() {
        return this.myPrintElementGenerator.getRecommendedWidth();
    }

    public LinearGraph getLinearGraph() {
        return this.myGraphController.getCompiledGraph();
    }

    @NotNull
    public PermanentGraphInfo<CommitId> getPermanentGraph() {
        PermanentGraphInfo<CommitId> permanentGraphInfo = this.myPermanentGraph;
        if (permanentGraphInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl", "getPermanentGraph"));
        }
        return permanentGraphInfo;
    }

    private class RowInfoImpl
    implements RowInfo<CommitId> {
        private final int myNodeId;
        private final int myVisibleRow;

        public RowInfoImpl(int nodeId, int visibleRow) {
            this.myNodeId = nodeId;
            this.myVisibleRow = visibleRow;
        }

        @NotNull
        public CommitId getCommit() {
            Object CommitId2 = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(this.myNodeId);
            if (CommitId2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl", "getCommit"));
            }
            return CommitId2;
        }

        @NotNull
        public CommitId getOneOfHeads() {
            int headNodeId = VisibleGraphImpl.this.myPermanentGraph.getPermanentGraphLayout().getOneOfHeadNodeIndex(this.myNodeId);
            Object CommitId2 = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(headNodeId);
            if (CommitId2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl", "getOneOfHeads"));
            }
            return CommitId2;
        }

        @NotNull
        public Collection<? extends PrintElement> getPrintElements() {
            Collection<PrintElementWithGraphElement> collection = VisibleGraphImpl.this.myPrintElementGenerator.getPrintElements(this.myVisibleRow);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl", "getPrintElements"));
            }
            return collection;
        }

        @NotNull
        public RowType getRowType() {
            GraphNodeType nodeType = VisibleGraphImpl.this.myGraphController.getCompiledGraph().getGraphNode(this.myVisibleRow).getType();
            switch (nodeType) {
                case USUAL: {
                    RowType rowType = RowType.NORMAL;
                    if (rowType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl", "getRowType"));
                    }
                    return rowType;
                }
                case UNMATCHED: {
                    RowType rowType = RowType.UNMATCHED;
                    if (rowType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl", "getRowType"));
                    }
                    return rowType;
                }
            }
            throw new UnsupportedOperationException("Unsupported node type: " + (Object)((Object)nodeType));
        }
    }

    public static class LinearGraphActionImpl
    implements LinearGraphController.LinearGraphAction {
        @Nullable
        private final PrintElementWithGraphElement myAffectedElement;
        @NotNull
        private final GraphAction.Type myType;

        public LinearGraphActionImpl(@Nullable PrintElementWithGraphElement affectedElement, @NotNull GraphAction.Type type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl", "<init>"));
            }
            this.myAffectedElement = affectedElement;
            this.myType = type2;
        }

        @Override
        @Nullable
        public PrintElementWithGraphElement getAffectedElement() {
            return this.myAffectedElement;
        }

        @NotNull
        public GraphAction.Type getType() {
            GraphAction.Type type2 = this.myType;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl", "getType"));
            }
            return type2;
        }
    }

    private static class GraphAnswerImpl<CommitId>
    implements GraphAnswer<CommitId> {
        @Nullable
        private final Cursor myCursor;
        @Nullable
        private final CommitId myCommitToJump;
        @Nullable
        private final Runnable myUpdater;
        private final boolean myDoJump;

        private GraphAnswerImpl(@Nullable Cursor cursor, @Nullable CommitId commitToJump, @Nullable Runnable updater, boolean doJump) {
            this.myCursor = cursor;
            this.myCommitToJump = commitToJump;
            this.myUpdater = updater;
            this.myDoJump = doJump;
        }

        @Nullable
        public Cursor getCursorToSet() {
            return this.myCursor;
        }

        @Nullable
        public CommitId getCommitToJump() {
            return this.myCommitToJump;
        }

        @Nullable
        public Runnable getGraphUpdater() {
            return this.myUpdater;
        }

        public boolean doJump() {
            return this.myDoJump;
        }
    }

    private class ActionControllerImpl
    implements ActionController<CommitId> {
        private ActionControllerImpl() {
        }

        @Nullable
        private Integer convertToNodeId(@Nullable Integer nodeIndex) {
            if (nodeIndex == null) {
                return null;
            }
            return VisibleGraphImpl.this.getNodeId(nodeIndex);
        }

        @Nullable
        private GraphAnswer<CommitId> performArrowAction(@NotNull LinearGraphController.LinearGraphAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performArrowAction"));
            }
            PrintElementWithGraphElement affectedElement = action.getAffectedElement();
            if (!(affectedElement instanceof EdgePrintElement)) {
                return null;
            }
            EdgePrintElement edgePrintElement = (EdgePrintElement)affectedElement;
            if (!edgePrintElement.hasArrow()) {
                return null;
            }
            GraphElement graphElement = affectedElement.getGraphElement();
            if (!(graphElement instanceof GraphEdge)) {
                return null;
            }
            GraphEdge edge = (GraphEdge)graphElement;
            Integer targetId = null;
            if (edge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                assert (edgePrintElement.getType().equals((Object)EdgePrintElement.Type.DOWN));
                targetId = edge.getTargetId();
            }
            if (edge.getType().isNormalEdge()) {
                targetId = edgePrintElement.getType().equals((Object)EdgePrintElement.Type.DOWN) ? this.convertToNodeId(edge.getDownNodeIndex()) : this.convertToNodeId(edge.getUpNodeIndex());
            }
            if (targetId == null) {
                return null;
            }
            if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                VisibleGraphImpl.this.myPrintElementManager.setSelectedElement(affectedElement);
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(true), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null, false);
            }
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(false), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null, true);
            }
            return null;
        }

        @NotNull
        public GraphAnswer<CommitId> performAction(@NotNull GraphAction graphAction) {
            if (graphAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphAction", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performAction"));
            }
            VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(Collections.emptySet());
            LinearGraphController.LinearGraphAction action = this.convert(graphAction);
            GraphAnswer graphAnswer = this.performArrowAction(action);
            if (graphAnswer != null) {
                GraphAnswer graphAnswer2 = graphAnswer;
                if (graphAnswer2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performAction"));
                }
                return graphAnswer2;
            }
            LinearGraphController.LinearGraphAnswer answer = VisibleGraphImpl.this.myGraphController.performLinearGraphAction(action);
            if (answer.getSelectedNodeIds() != null) {
                VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(answer.getSelectedNodeIds());
            }
            if (answer.getGraphChanges() != null) {
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }
            GraphAnswer graphAnswer3 = this.convert(answer);
            if (graphAnswer3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "performAction"));
            }
            return graphAnswer3;
        }

        public boolean areLongEdgesHidden() {
            return !VisibleGraphImpl.this.myShowLongEdges;
        }

        public void setLongEdgesHidden(boolean longEdgesHidden) {
            VisibleGraphImpl.this.myShowLongEdges = !longEdgesHidden;
            VisibleGraphImpl.this.updatePrintElementGenerator();
        }

        private LinearGraphController.LinearGraphAction convert(@NotNull GraphAction graphAction) {
            if (graphAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphAction", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "convert"));
            }
            PrintElementWithGraphElement printElement = null;
            if (graphAction.getAffectedElement() != null) {
                printElement = VisibleGraphImpl.this.myPrintElementGenerator.withGraphElement(graphAction.getAffectedElement());
            }
            return new LinearGraphActionImpl(printElement, graphAction.getType());
        }

        private GraphAnswer<CommitId> convert(@NotNull LinearGraphController.LinearGraphAnswer answer) {
            if (answer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl", "convert"));
            }
            Runnable graphUpdater = answer.getGraphUpdater();
            return new GraphAnswerImpl(answer.getCursorToSet(), null, graphUpdater == null ? null : () -> {
                graphUpdater.run();
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }, false);
        }
    }
}

