/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrintElementGenerator
implements PrintElementGenerator {
    @NotNull
    protected final LinearGraph myLinearGraph;
    @NotNull
    protected final PrintElementManager myPrintElementManager;

    protected AbstractPrintElementGenerator(@NotNull LinearGraph linearGraph, @NotNull PrintElementManager printElementManager) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "<init>"));
        }
        this.myLinearGraph = linearGraph;
        this.myPrintElementManager = printElementManager;
    }

    @Override
    @NotNull
    public Collection<PrintElementWithGraphElement> getPrintElements(int rowIndex) {
        RowElementType rowElementType;
        ArrayList<PrintElementWithGraphElement> result2 = new ArrayList<PrintElementWithGraphElement>();
        Collection<SimpleRowElement> simpleRowElements = this.getSimpleRowElements(rowIndex);
        HashMap arrows = ContainerUtil.newHashMap();
        for (SimpleRowElement rowElement : simpleRowElements) {
            if (rowElement.myType.equals((Object)RowElementType.NODE)) continue;
            arrows.put((GraphEdge)rowElement.myElement, rowElement);
        }
        if (rowIndex < this.myLinearGraph.nodesCount() - 1) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex)) {
                rowElementType = RowElementType.NODE;
                if (arrows.get(shortEdge.myEdge) != null && RowElementType.DOWN_ARROW.equals((Object)((SimpleRowElement)arrows.get((Object)shortEdge.myEdge)).myType)) {
                    rowElementType = RowElementType.DOWN_ARROW;
                    arrows.remove(shortEdge.myEdge);
                }
                result2.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.DOWN, !rowElementType.equals((Object)RowElementType.NODE)));
            }
        }
        if (rowIndex > 0) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex - 1)) {
                rowElementType = RowElementType.NODE;
                if (arrows.get(shortEdge.myEdge) != null && RowElementType.UP_ARROW.equals((Object)((SimpleRowElement)arrows.get((Object)shortEdge.myEdge)).myType)) {
                    rowElementType = RowElementType.UP_ARROW;
                    arrows.remove(shortEdge.myEdge);
                }
                result2.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.UP, !rowElementType.equals((Object)RowElementType.NODE)));
            }
        }
        for (SimpleRowElement arrow : arrows.values()) {
            result2.add(new TerminalEdgePrintElement(rowIndex, arrow.myPosition, arrow.myType == RowElementType.UP_ARROW ? EdgePrintElement.Type.UP : EdgePrintElement.Type.DOWN, (GraphEdge)arrow.myElement, this.myPrintElementManager));
        }
        for (SimpleRowElement rowElement : simpleRowElements) {
            if (!rowElement.myType.equals((Object)RowElementType.NODE)) continue;
            result2.add(this.createSimplePrintElement(rowIndex, rowElement));
        }
        ArrayList<PrintElementWithGraphElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "getPrintElements"));
        }
        return arrayList;
    }

    @NotNull
    private SimplePrintElementImpl createSimplePrintElement(int rowIndex, @NotNull SimpleRowElement rowElement) {
        if (rowElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowElement", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createSimplePrintElement"));
        }
        SimplePrintElementImpl simplePrintElementImpl = new SimplePrintElementImpl(rowIndex, rowElement.myPosition, rowElement.myElement, this.myPrintElementManager);
        if (simplePrintElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createSimplePrintElement"));
        }
        return simplePrintElementImpl;
    }

    @NotNull
    private EdgePrintElementImpl createEdgePrintElement(int rowIndex, @NotNull ShortEdge shortEdge, @NotNull EdgePrintElement.Type type2, boolean hasArrow) {
        int positionInOtherRow;
        int positionInCurrentRow;
        if (shortEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortEdge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        if (type2 == EdgePrintElement.Type.DOWN) {
            positionInCurrentRow = shortEdge.myUpPosition;
            positionInOtherRow = shortEdge.myDownPosition;
        } else {
            positionInCurrentRow = shortEdge.myDownPosition;
            positionInOtherRow = shortEdge.myUpPosition;
        }
        EdgePrintElementImpl edgePrintElementImpl = new EdgePrintElementImpl(rowIndex, positionInCurrentRow, positionInOtherRow, type2, shortEdge.myEdge, hasArrow, this.myPrintElementManager);
        if (edgePrintElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        return edgePrintElementImpl;
    }

    @Override
    @NotNull
    public PrintElementWithGraphElement withGraphElement(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "withGraphElement"));
        }
        if (printElement instanceof PrintElementWithGraphElement) {
            PrintElementWithGraphElement printElementWithGraphElement = (PrintElementWithGraphElement)printElement;
            if (printElementWithGraphElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "withGraphElement"));
            }
            return printElementWithGraphElement;
        }
        int rowIndex = printElement.getRowIndex();
        for (PrintElementWithGraphElement printElementWithGE : this.getPrintElements(rowIndex)) {
            if (!printElementWithGE.equals(printElement)) continue;
            PrintElementWithGraphElement printElementWithGraphElement = printElementWithGE;
            if (printElementWithGraphElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "withGraphElement"));
            }
            return printElementWithGraphElement;
        }
        throw new IllegalStateException("Not found graphElement for this printElement: " + printElement);
    }

    @NotNull
    protected abstract Collection<ShortEdge> getDownShortEdges(int var1);

    @NotNull
    protected abstract Collection<SimpleRowElement> getSimpleRowElements(int var1);

    static enum RowElementType {
        NODE,
        UP_ARROW,
        DOWN_ARROW;

    }

    protected static class SimpleRowElement {
        @NotNull
        public final GraphElement myElement;
        @NotNull
        public final RowElementType myType;
        public final int myPosition;

        public SimpleRowElement(@NotNull GraphElement element, @NotNull RowElementType type2, int position) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement", "<init>"));
            }
            this.myElement = element;
            this.myPosition = position;
            this.myType = type2;
        }
    }

    protected static class ShortEdge {
        @NotNull
        public final GraphEdge myEdge;
        public final int myUpPosition;
        public final int myDownPosition;

        public ShortEdge(@NotNull GraphEdge edge, int upPosition, int downPosition) {
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$ShortEdge", "<init>"));
            }
            this.myEdge = edge;
            this.myUpPosition = upPosition;
            this.myDownPosition = downPosition;
        }
    }
}

