/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.util.BooleanFunction;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.IDIntToIntMap;
import org.jetbrains.annotations.NotNull;

public class ListIntToIntMap
extends AbstractIntToIntMap
implements UpdatableIntToIntMap {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    @NotNull
    final BooleanFunction<Integer> myThisIsVisible;
    private final int myLongSize;
    private final int myBlockSize;
    private final int[] mySubSumOfBlocks;

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize) {
        if (thisIsVisible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisIsVisible", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "newInstance"));
        }
        UpdatableIntToIntMap updatableIntToIntMap = ListIntToIntMap.newInstance(thisIsVisible, longSize, 30);
        if (updatableIntToIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "newInstance"));
        }
        return updatableIntToIntMap;
    }

    @NotNull
    public static UpdatableIntToIntMap newInstance(Flags visibleNodes) {
        UpdatableIntToIntMap updatableIntToIntMap = ListIntToIntMap.newInstance((BooleanFunction<Integer>)((BooleanFunction)integer -> visibleNodes.get((int)integer)), visibleNodes.size());
        if (updatableIntToIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "newInstance"));
        }
        return updatableIntToIntMap;
    }

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize, int blockSize) {
        if (thisIsVisible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisIsVisible", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "newInstance"));
        }
        if (longSize < 0) {
            throw new NegativeArraySizeException("size < 0: " + longSize);
        }
        if (longSize == 0) {
            UpdatableIntToIntMap updatableIntToIntMap = IDIntToIntMap.EMPTY;
            if (updatableIntToIntMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "newInstance"));
            }
            return updatableIntToIntMap;
        }
        int sumSize = (longSize - 1) / blockSize + 1;
        ListIntToIntMap listIntToIntMap = new ListIntToIntMap(thisIsVisible, longSize, blockSize, new int[sumSize]);
        listIntToIntMap.update(0, longSize - 1);
        ListIntToIntMap listIntToIntMap2 = listIntToIntMap;
        if (listIntToIntMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "newInstance"));
        }
        return listIntToIntMap2;
    }

    private ListIntToIntMap(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize, int blockSize, int[] subSumOfBlocks) {
        if (thisIsVisible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisIsVisible", "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap", "<init>"));
        }
        this.myLongSize = longSize;
        this.myThisIsVisible = thisIsVisible;
        this.myBlockSize = blockSize;
        this.mySubSumOfBlocks = subSumOfBlocks;
    }

    @Override
    public int shortSize() {
        return this.mySubSumOfBlocks[this.mySubSumOfBlocks.length - 1];
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    private int getRelevantSumIndex(int longIndex) {
        return longIndex / this.myBlockSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int a = 0;
        int b = this.mySubSumOfBlocks.length - 1;
        while (b > a) {
            int middle = (a + b) / 2;
            if (this.mySubSumOfBlocks[middle] <= shortIndex) {
                a = middle + 1;
                continue;
            }
            b = middle;
        }
        assert (a == b);
        int blockIndex = a;
        int prefVisibleCount = 0;
        if (blockIndex > 0) {
            prefVisibleCount = this.mySubSumOfBlocks[blockIndex - 1];
        }
        for (int longIndex = blockIndex * this.myBlockSize; longIndex < this.myLongSize; ++longIndex) {
            if (this.myThisIsVisible.fun((Object)longIndex)) {
                ++prefVisibleCount;
            }
            if (prefVisibleCount <= shortIndex) continue;
            return longIndex;
        }
        throw new IllegalAccessError("This should never happen!");
    }

    @Override
    public int getShortIndex(int longIndex) {
        this.checkLongIndex(longIndex);
        int blockIndex = this.getRelevantSumIndex(longIndex);
        int countVisible = this.calculateSumForBlock(blockIndex, longIndex);
        if (countVisible > 0) {
            return countVisible - 1;
        }
        return 0;
    }

    private int calculateSumForBlock(int blockIndex, int lastLongIndex) {
        int sum = 0;
        if (blockIndex > 0) {
            sum = this.mySubSumOfBlocks[blockIndex - 1];
        }
        for (int longIndex = blockIndex * this.myBlockSize; longIndex <= lastLongIndex; ++longIndex) {
            if (!this.myThisIsVisible.fun((Object)longIndex)) continue;
            ++sum;
        }
        return sum;
    }

    private void updateSumWithCorrectPrevious(int blockIndex) {
        int endIndex = Math.min(this.myLongSize, (blockIndex + 1) * this.myBlockSize);
        this.mySubSumOfBlocks[blockIndex] = this.calculateSumForBlock(blockIndex, endIndex - 1);
    }

    @Override
    public void update(int startLongIndex, int endLongIndex) {
        this.checkUpdateParameters(startLongIndex, endLongIndex);
        int startSumIndex = this.getRelevantSumIndex(startLongIndex);
        int endSumIndex = this.getRelevantSumIndex(endLongIndex);
        int prevEndSum = this.mySubSumOfBlocks[endSumIndex];
        for (int blockIndex = startSumIndex; blockIndex <= endSumIndex; ++blockIndex) {
            this.updateSumWithCorrectPrevious(blockIndex);
        }
        int sumDelta = this.mySubSumOfBlocks[endSumIndex] - prevEndSum;
        int blockIndex = endSumIndex + 1;
        while (blockIndex < this.mySubSumOfBlocks.length) {
            int n = blockIndex++;
            this.mySubSumOfBlocks[n] = this.mySubSumOfBlocks[n] + sumDelta;
        }
    }
}

