/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.BfsUtil;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileHistoryFilterer
extends VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(FileHistoryFilterer.class);
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final IndexDataGetter myIndexDataGetter;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryFilterer(@NotNull VcsLogData logData, @NotNull FilePath filePath) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/history/FileHistoryFilterer", "<init>"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/vcs/log/history/FileHistoryFilterer", "<init>"));
        }
        super(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex());
        this.myFilePath = filePath;
        this.myIndexDataGetter = (IndexDataGetter)ObjectUtils.assertNotNull((Object)this.myIndex.getDataGetter());
        this.myRoot = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsUtil.getVcsRootFor((Project)logData.getProject(), (FilePath)this.myFilePath));
    }

    @Override
    @NotNull
    protected VisiblePack createVisiblePack(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @Nullable Set<Integer> matchingHeads, @NotNull VcsLogFilterer.FilterByDetailsResult filterResult) {
        FileHistoryRefiner refiner;
        int row;
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/history/FileHistoryFilterer", "createVisiblePack"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/history/FileHistoryFilterer", "createVisiblePack"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/history/FileHistoryFilterer", "createVisiblePack"));
        }
        if (filterResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterResult", "com/intellij/vcs/log/history/FileHistoryFilterer", "createVisiblePack"));
        }
        if (!(filterResult instanceof FilteredByFileResult) || filterResult.matchingCommits == null) {
            VisiblePack visiblePack = super.createVisiblePack(dataPack, sortType, filters, matchingHeads, filterResult);
            if (visiblePack == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryFilterer", "createVisiblePack"));
            }
            return visiblePack;
        }
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, filterResult.matchingCommits);
        IndexDataGetter.FileNamesData namesData = ((FilteredByFileResult)filterResult).fileNamesData;
        Map<Integer, FilePath> pathsMap = null;
        if (visibleGraph.getVisibleCommitCount() > 0 && visibleGraph instanceof VisibleGraphImpl && (row = this.getCurrentRow(dataPack, visibleGraph, namesData)) >= 0 && (refiner = new FileHistoryRefiner((VisibleGraphImpl)visibleGraph, namesData)).refine(row, this.myFilePath)) {
            visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, refiner.getPathsForCommits().keySet());
            pathsMap = refiner.getPathsForCommits();
        }
        if (pathsMap == null) {
            pathsMap = namesData.buildPathsMap();
        }
        FileHistoryVisiblePack fileHistoryVisiblePack = new FileHistoryVisiblePack(dataPack, visibleGraph, filterResult.canRequestMore, filters, pathsMap);
        if (fileHistoryVisiblePack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryFilterer", "createVisiblePack"));
        }
        return fileHistoryVisiblePack;
    }

    @Override
    @NotNull
    protected VcsLogFilterer.FilterByDetailsResult filterByDetails(@NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount, @NotNull Collection<VirtualFile> visibleRoots, @Nullable Set<Integer> matchingHeads) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/history/FileHistoryFilterer", "filterByDetails"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/history/FileHistoryFilterer", "filterByDetails"));
        }
        if (commitCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitCount", "com/intellij/vcs/log/history/FileHistoryFilterer", "filterByDetails"));
        }
        if (visibleRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleRoots", "com/intellij/vcs/log/history/FileHistoryFilterer", "filterByDetails"));
        }
        List detailsFilters = filters.getDetailsFilters();
        if (this.myIndex.isIndexed(this.myRoot)) {
            LOG.assertTrue(detailsFilters.size() == 1);
            VcsLogDetailsFilter filter = (VcsLogDetailsFilter)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)detailsFilters));
            LOG.assertTrue(filter instanceof VcsLogStructureFilter);
            LOG.assertTrue(((VcsLogStructureFilter)filter).getFiles().equals(Collections.singleton(this.myFilePath)));
            IndexDataGetter.FileNamesData data = this.myIndexDataGetter.buildFileNamesData(this.myFilePath);
            FilteredByFileResult filteredByFileResult = new FilteredByFileResult(data, data.getCommits(), false, commitCount);
            if (filteredByFileResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryFilterer", "filterByDetails"));
            }
            return filteredByFileResult;
        }
        VcsLogFilterer.FilterByDetailsResult filterByDetailsResult = super.filterByDetails(dataPack, filters, commitCount, visibleRoots, matchingHeads);
        if (filterByDetailsResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryFilterer", "filterByDetails"));
        }
        return filterByDetailsResult;
    }

    private int getCurrentRow(@NotNull DataPack pack, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData fileIndexData) {
        CompressedRefs refs;
        Optional<VcsRef> headOptional;
        if (pack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pack", "com/intellij/vcs/log/history/FileHistoryFilterer", "getCurrentRow"));
        }
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/history/FileHistoryFilterer", "getCurrentRow"));
        }
        if (fileIndexData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndexData", "com/intellij/vcs/log/history/FileHistoryFilterer", "getCurrentRow"));
        }
        PermanentGraph<Integer> permanentGraph = pack.getPermanentGraph();
        if (permanentGraph instanceof PermanentGraphImpl && (headOptional = (refs = pack.getRefsModel().getAllRefsByRoot().get(this.myRoot)).streamBranches().filter(br -> br.getName().equals("HEAD")).findFirst()).isPresent()) {
            VcsRef head = headOptional.get();
            assert (head.getRoot().equals(this.myRoot));
            return this.findAncestorRowAffectingFile((PermanentGraphImpl)permanentGraph, head.getCommitHash(), visibleGraph, fileIndexData);
        }
        return -1;
    }

    private int findAncestorRowAffectingFile(@NotNull PermanentGraphImpl<Integer> permanentGraph, @NotNull Hash hash, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData fileNamesData) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/history/FileHistoryFilterer", "findAncestorRowAffectingFile"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/history/FileHistoryFilterer", "findAncestorRowAffectingFile"));
        }
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/history/FileHistoryFilterer", "findAncestorRowAffectingFile"));
        }
        if (fileNamesData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamesData", "com/intellij/vcs/log/history/FileHistoryFilterer", "findAncestorRowAffectingFile"));
        }
        Ref result2 = new Ref();
        PermanentCommitsInfo commitsInfo = permanentGraph.getPermanentCommitsInfo();
        ReachableNodes reachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph.getLinearGraph()));
        reachableNodes.walk(Collections.singleton(((PermanentCommitsInfoImpl)commitsInfo).getNodeId(this.myStorage.getCommitIndex(hash, this.myRoot))), true, arg_0 -> this.lambda$findAncestorRowAffectingFile$1((PermanentCommitsInfoImpl)commitsInfo, fileNamesData, result2, arg_0));
        if (!result2.isNull()) {
            Integer rowIndex = visibleGraph.getVisibleRowIndex(((PermanentCommitsInfoImpl)commitsInfo).getCommitId((Integer)result2.get()));
            return (Integer)ObjectUtils.assertNotNull((Object)rowIndex);
        }
        return -1;
    }

    private /* synthetic */ boolean lambda$findAncestorRowAffectingFile$1(PermanentCommitsInfoImpl commitsInfo, @NotNull IndexDataGetter.FileNamesData fileNamesData, Ref result2, int currentNode) {
        if (fileNamesData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamesData", "com/intellij/vcs/log/history/FileHistoryFilterer", "lambda$findAncestorRowAffectingFile$1"));
        }
        int id = (Integer)commitsInfo.getCommitId(currentNode);
        if (fileNamesData.affects(id, this.myFilePath)) {
            result2.set((Object)currentNode);
            return false;
        }
        return true;
    }

    private static class FilteredByFileResult
    extends VcsLogFilterer.FilterByDetailsResult {
        @NotNull
        public final IndexDataGetter.FileNamesData fileNamesData;

        public FilteredByFileResult(@NotNull IndexDataGetter.FileNamesData data, @Nullable Set<Integer> commits, boolean more, @NotNull CommitCountStage count) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/history/FileHistoryFilterer$FilteredByFileResult", "<init>"));
            }
            if (count == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "count", "com/intellij/vcs/log/history/FileHistoryFilterer$FilteredByFileResult", "<init>"));
            }
            super(commits, more, count);
            this.fileNamesData = data;
        }
    }

    private static class FileHistoryRefiner
    implements DfsUtil.NodeVisitor {
        @NotNull
        private final VisibleGraphImpl<Integer> myVisibleGraph;
        @NotNull
        private final PermanentCommitsInfo<Integer> myPermanentCommitsInfo;
        @NotNull
        private final LiteLinearGraph myPermanentLinearGraph;
        @NotNull
        private final IndexDataGetter.FileNamesData myNamesData;
        @NotNull
        private final Stack<FilePath> myPaths;
        @NotNull
        private final BitSetFlags myVisibilityBuffer;
        @NotNull
        private final Map<Integer, FilePath> myPathsForCommits;
        @NotNull
        private final Set<Integer> myExcluded;

        public FileHistoryRefiner(@NotNull VisibleGraphImpl<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData namesData) {
            if (visibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner", "<init>"));
            }
            if (namesData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesData", "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner", "<init>"));
            }
            this.myPaths = new Stack();
            this.myPathsForCommits = ContainerUtil.newHashMap();
            this.myExcluded = ContainerUtil.newHashSet();
            this.myVisibleGraph = visibleGraph;
            this.myPermanentCommitsInfo = this.myVisibleGraph.getPermanentGraph().getPermanentCommitsInfo();
            this.myPermanentLinearGraph = LinearGraphUtils.asLiteLinearGraph(this.myVisibleGraph.getPermanentGraph().getLinearGraph());
            this.myNamesData = namesData;
            this.myVisibilityBuffer = new BitSetFlags(this.myPermanentLinearGraph.nodesCount());
        }

        public boolean refine(int row, @NotNull FilePath startPath) {
            if (startPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPath", "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner", "refine"));
            }
            if (this.myNamesData.hasRenames()) {
                this.myPaths.push((Object)startPath);
                DfsUtil.walk(LinearGraphUtils.asLiteLinearGraph(this.myVisibleGraph.getLinearGraph()), row, this);
            } else {
                this.myPathsForCommits.putAll(this.myNamesData.buildPathsMap());
            }
            for (int commit : this.myPathsForCommits.keySet()) {
                FilePath path = this.myPathsForCommits.get(commit);
                if (path == null) continue;
                if (!this.myNamesData.affects(commit, path)) {
                    this.myExcluded.add(commit);
                }
                if (!this.myNamesData.isTrivialMerge(commit, path)) continue;
                this.myExcluded.add(commit);
            }
            this.myExcluded.forEach(this.myPathsForCommits::remove);
            return !this.myExcluded.isEmpty();
        }

        @NotNull
        public Map<Integer, FilePath> getPathsForCommits() {
            Map<Integer, FilePath> map2 = this.myPathsForCommits;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner", "getPathsForCommits"));
            }
            return map2;
        }

        @Override
        public void enterNode(int currentNode, int previousNode, boolean down) {
            FilePath previousPath;
            int currentNodeId = this.myVisibleGraph.getNodeId(currentNode);
            int currentCommit = this.myPermanentCommitsInfo.getCommitId(currentNodeId);
            FilePath currentPath = previousPath = (FilePath)ObjectUtils.notNull((Object)ContainerUtil.findLast(this.myPaths, path -> path != null));
            if (previousNode != -1) {
                int previousNodeId = this.myVisibleGraph.getNodeId(previousNode);
                int previousCommit = this.myPermanentCommitsInfo.getCommitId(previousNodeId);
                if (down) {
                    Function pathGetter = parentIndex -> this.myNamesData.getPathInParentRevision(previousCommit, this.myPermanentCommitsInfo.getCommitId((int)parentIndex), previousPath);
                    currentPath = this.findPathWithoutConflict(previousNodeId, (Function<Integer, FilePath>)pathGetter);
                    if (currentPath == null) {
                        int parentIndex2 = BfsUtil.getCorrespondingParent(this.myPermanentLinearGraph, previousNodeId, currentNodeId, this.myVisibilityBuffer);
                        currentPath = (FilePath)pathGetter.fun((Object)parentIndex2);
                    }
                } else {
                    Function pathGetter = parentIndex -> this.myNamesData.getPathInChildRevision(currentCommit, this.myPermanentCommitsInfo.getCommitId((int)parentIndex), previousPath);
                    currentPath = this.findPathWithoutConflict(currentNodeId, (Function<Integer, FilePath>)pathGetter);
                    if (currentPath == null) {
                        int parentIndex3 = BfsUtil.getCorrespondingParent(this.myPermanentLinearGraph, currentNodeId, previousNodeId, this.myVisibilityBuffer);
                        currentPath = (FilePath)pathGetter.fun((Object)parentIndex3);
                    }
                }
            }
            this.myPathsForCommits.put(currentCommit, currentPath);
            this.myPaths.push((Object)currentPath);
        }

        @Nullable
        private FilePath findPathWithoutConflict(int nodeId, @NotNull Function<Integer, FilePath> pathGetter) {
            if (pathGetter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathGetter", "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner", "findPathWithoutConflict"));
            }
            List<Integer> parents = this.myPermanentLinearGraph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            FilePath path = (FilePath)pathGetter.fun((Object)parents.get(0));
            if (parents.size() == 1) {
                return path;
            }
            for (Integer parent : ContainerUtil.subList(parents, (int)1)) {
                if (Objects.equals(pathGetter.fun((Object)parent), path)) continue;
                return null;
            }
            return path;
        }

        @Override
        public void exitNode(int node) {
            this.myPaths.pop();
        }
    }
}

