/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final String TAB_NAME = "History";

    public boolean canShowFileHistory(@NotNull Project project2, @NotNull FilePath path) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl", "canShowFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl", "canShowFileHistory"));
        }
        if (!Registry.is((String)"vcs.new.history")) {
            return false;
        }
        VcsRoot rootObject = ProjectLevelVcsManager.getInstance((Project)project2).getVcsRootObjectFor(path);
        if (rootObject == null) {
            return false;
        }
        VirtualFile root = rootObject.getPath();
        AbstractVcs vcs = rootObject.getVcs();
        if (vcs == null || root == null) {
            return false;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project2).getDataManager();
        if (dataManager == null || !dataManager.getRoots().contains(root) || dataManager.getIndex().getDataGetter() == null) {
            return false;
        }
        List<Object> allLogProviders = Arrays.asList(Extensions.getExtensions((ExtensionPointName)VcsLogProvider.LOG_PROVIDER_EP, (AreaInstance)project2));
        VcsLogProvider provider = (VcsLogProvider)ContainerUtil.find(allLogProviders, p -> p.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod()));
        if (provider == null) {
            return false;
        }
        return (Boolean)VcsLogProperties.get((VcsLogProvider)provider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING);
    }

    public void showFileHistory(@NotNull Project project2, @NotNull FilePath path, @Nullable String revisionNumber) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl", "showFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl", "showFileHistory"));
        }
        if (!VcsLogContentProvider.findAndSelectContent(project2, FileHistoryUi.class, ui -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl", "lambda$showFileHistory$1"));
            }
            return ui.getPath().equals(path);
        })) {
            VcsLogManager logManager = VcsProjectLog.getInstance(project2).getLogManager();
            assert (logManager != null);
            VcsLogContentProvider.openLogTab(project2, logManager, TAB_NAME, path.getName(), new FileHistoryUiFactory(path));
        }
    }
}

