/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightersActionGroup
extends ActionGroup {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        ArrayList actions = ContainerUtil.newArrayList();
        if (e != null && e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES) != null) {
            actions.add(new Separator("Highlight"));
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions(AbstractVcsLogUi.LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)e.getProject())) {
                if (!factory.showMenuItem()) continue;
                actions.add(new EnableHighlighterAction(factory));
            }
        }
        AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/HighlightersActionGroup", "getChildren"));
        }
        return anActionArray;
    }

    private static class EnableHighlighterAction
    extends BooleanPropertyToggleAction {
        @NotNull
        private final VcsLogHighlighterFactory myFactory;

        private EnableHighlighterAction(@NotNull VcsLogHighlighterFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/vcs/log/ui/actions/HighlightersActionGroup$EnableHighlighterAction", "<init>"));
            }
            super(factory.getTitle());
            this.myFactory = factory;
        }

        @Override
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return MainVcsLogUiProperties.VcsLogHighlighterProperty.get(this.myFactory.getId());
        }
    }
}

