/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.ui.FlatSpeedSearchPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter> {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<String> myAllUsers;

    UserFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogData logData, @NotNull FilterModel<VcsLogUserFilter> filterModel) {
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        super("User", uiProperties, filterModel);
        this.myLogData = logData;
        this.myAllUsers = UserFilterPopupComponent.collectUsers(logData);
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogUserFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getText"));
        }
        String string = UserFilterPopupComponent.displayableText(this.myFilterModel.getFilterValues(filter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogUserFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getToolTip"));
        }
        return UserFilterPopupComponent.tooltip(this.myFilterModel.getFilterValues(filter));
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createAllAction());
        group.add(this.createSelectMultipleValuesAction());
        if (!this.myLogData.getCurrentUser().isEmpty()) {
            group.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction((MultipleValueFilterPopupComponent)this, "me"));
        }
        group.addAll(this.createRecentItemsActionGroup());
        return group;
    }

    @NotNull
    protected ActionGroup createSpeedSearchActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SpeedsearchPredefinedValueAction("me"));
        group.add((AnAction)Separator.getInstance());
        for (String user : this.myAllUsers) {
            group.add((AnAction)new SpeedsearchPredefinedValueAction(user));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "createSpeedSearchActionGroup"));
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list2 = this.myUiProperties.getRecentlyFilteredUserGroups();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list2;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "rememberValuesInSettings"));
        }
        this.myUiProperties.addRecentlyFilteredUserGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List<String> list2 = this.myAllUsers;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getAllValues"));
        }
        return list2;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        ActionGroup actionGroup = this.createActionGroup();
        ActionGroup speedsearchGroup = this.createSpeedSearchActionGroup();
        UserLogSpeedSearchPopup userLogSpeedSearchPopup = new UserLogSpeedSearchPopup(new DefaultActionGroup(new AnAction[]{actionGroup, speedsearchGroup}), DataManager.getInstance().getDataContext((Component)this));
        if (userLogSpeedSearchPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "createPopupMenu"));
        }
        return userLogSpeedSearchPopup;
    }

    @NotNull
    private static List<String> collectUsers(@NotNull VcsLogData logData) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "collectUsers"));
        }
        List users = ContainerUtil.map(logData.getAllUsers(), user -> {
            String shortPresentation = VcsUserUtil.getShortPresentation(user);
            Couple<String> firstAndLastName = VcsUserUtil.getFirstAndLastName(shortPresentation);
            if (firstAndLastName == null) {
                return shortPresentation;
            }
            return VcsUserUtil.capitalizeName((String)firstAndLastName.first) + " " + VcsUserUtil.capitalizeName((String)firstAndLastName.second);
        });
        TreeSet sortedUniqueUsers = new TreeSet(users);
        ArrayList<String> arrayList = new ArrayList<String>(sortedUniqueUsers);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "collectUsers"));
        }
        return arrayList;
    }

    private class SpeedsearchPredefinedValueAction
    extends MultipleValueFilterPopupComponent.PredefinedValueAction
    implements FlatSpeedSearchPopup.SpeedsearchAction {
        public SpeedsearchPredefinedValueAction(String user) {
            super((MultipleValueFilterPopupComponent)UserFilterPopupComponent.this, user);
        }
    }

    private static class UserLogSpeedSearchPopup
    extends FlatSpeedSearchPopup {
        public UserLogSpeedSearchPopup(@NotNull DefaultActionGroup actionGroup, @NotNull DataContext dataContext) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$UserLogSpeedSearchPopup", "<init>"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$UserLogSpeedSearchPopup", "<init>"));
            }
            super(null, actionGroup, dataContext, null, false);
        }

        @Override
        public boolean shouldBeShowing(@NotNull AnAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$UserLogSpeedSearchPopup", "shouldBeShowing"));
            }
            if (!super.shouldBeShowing(action)) {
                return false;
            }
            if (this.getSpeedSearch().isHoldingFilter()) {
                if (action instanceof MultipleValueFilterPopupComponent.PredefinedValueAction) {
                    return action instanceof FlatSpeedSearchPopup.SpeedsearchAction || ((MultipleValueFilterPopupComponent.PredefinedValueAction)action).myValues.size() > 1;
                }
                return true;
            }
            return !UserLogSpeedSearchPopup.isSpeedsearchAction(action);
        }
    }
}

