/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.PlusMinus;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectionManager;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsStructureChooser
extends DialogWrapper {
    private static final int MAX_FOLDERS = 100;
    public static final Border BORDER = IdeBorderFactory.createBorder((int)3);
    public static final String CAN_NOT_ADD_TEXT = "<html>Selected: <font color=red>(You have added 100 elements. No more is allowed.)</font></html>";
    private static final String VCS_STRUCTURE_CHOOSER_KEY = "git4idea.history.wholeTree.VcsStructureChooser";
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, String> myModulesSet;
    @NotNull
    private final Set<VirtualFile> mySelectedFiles;
    @NotNull
    private final SelectionManager mySelectionManager;
    private Tree myTree;

    public VcsStructureChooser(@NotNull Project project2, @NotNull String title, @NotNull Collection<VirtualFile> initialSelection, @NotNull List<VirtualFile> roots) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "<init>"));
        }
        if (initialSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSelection", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "<init>"));
        }
        super(project2, true);
        this.mySelectedFiles = ContainerUtil.newHashSet();
        this.setTitle(title);
        this.myProject = project2;
        this.myRoots = roots;
        this.mySelectionManager = new SelectionManager(100, 500, MyNodeConverter.getInstance());
        this.myModulesSet = this.calculateModules(roots);
        this.init();
        this.mySelectionManager.setSelection(initialSelection);
        this.checkEmpty();
    }

    @NotNull
    private Map<VirtualFile, String> calculateModules(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "calculateModules"));
        }
        HashMap result2 = ContainerUtil.newHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = (Module[])ReadAction.compute(() -> moduleManager.getModules());
        TreeSet<VirtualFile> checkSet = new TreeSet<VirtualFile>((Comparator<VirtualFile>)FilePathComparator.getInstance());
        checkSet.addAll(roots);
        for (Module module2 : modules) {
            VirtualFile[] files;
            for (VirtualFile file2 : files = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                VirtualFile floor = checkSet.floor(file2);
                if (floor == null) continue;
                result2.put(file2, module2.getName());
            }
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "calculateModules"));
        }
        return hashMap;
    }

    @NotNull
    public Collection<VirtualFile> getSelectedFiles() {
        Set<VirtualFile> set2 = this.mySelectedFiles;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "getSelectedFiles"));
        }
        return set2;
    }

    private void checkEmpty() {
        this.setOKActionEnabled(!this.mySelectedFiles.isEmpty());
    }

    @NotNull
    protected String getDimensionServiceKey() {
        if (VCS_STRUCTURE_CHOOSER_KEY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "getDimensionServiceKey"));
        }
        return VCS_STRUCTURE_CHOOSER_KEY;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "getPreferredFocusedComponent"));
        }
        return tree;
    }

    protected JComponent createCenterPanel() {
        this.myTree = new Tree();
        this.myTree.setBorder(BORDER);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setExpandableItemsEnabled(false);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, true){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (!super.isFileVisible(file2, showHiddenFiles)) {
                    return false;
                }
                if (VcsStructureChooser.this.myRoots.contains(file2)) {
                    return false;
                }
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)VcsStructureChooser.this.myProject);
                return !changeListManager.isIgnoredFile(file2) && !changeListManager.isUnversioned(file2);
            }
        };
        descriptor.withRoots(new ArrayList<VirtualFile>(this.myRoots)).withShowHiddenFiles(true).withHideIgnored(true);
        final MyCheckboxTreeCellRenderer cellRenderer = new MyCheckboxTreeCellRenderer(this.mySelectionManager, this.myModulesSet, this.myProject, (JTree)this.myTree, this.myRoots);
        FileSystemTreeImpl fileSystemTree = new FileSystemTreeImpl(this.myProject, descriptor, this.myTree, cellRenderer, null, (Convertor<TreePath, String>)((Convertor)o -> {
            DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)o.getLastPathComponent();
            Object uo = lastPathComponent.getUserObject();
            if (uo instanceof FileNodeDescriptor) {
                VirtualFile file2 = ((FileNodeDescriptor)((Object)((Object)uo))).getElement().getFile();
                String module2 = this.myModulesSet.get(file2);
                if (module2 != null) {
                    return module2;
                }
                return file2 == null ? "" : file2.getName();
            }
            return o.toString();
        }));
        fileSystemTree.getTreeBuilder().getUi().setNodeDescriptorComparator((o1, o2) -> {
            if (o1 instanceof FileNodeDescriptor && o2 instanceof FileNodeDescriptor) {
                boolean isDir2;
                VirtualFile f1 = ((FileNodeDescriptor)((Object)o1)).getElement().getFile();
                VirtualFile f2 = ((FileNodeDescriptor)((Object)o2)).getElement().getFile();
                boolean isDir1 = f1.isDirectory();
                if (isDir1 != (isDir2 = f2.isDirectory())) {
                    return isDir1 ? -1 : 1;
                }
                return f1.getPath().compareToIgnoreCase(f2.getPath());
            }
            return o1.getIndex() - o2.getIndex();
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$2", "onClick"));
                }
                int row = VcsStructureChooser.this.myTree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = VcsStructureChooser.this.myTree.getPathForRow(row).getLastPathComponent();
                if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                    return false;
                }
                Rectangle rowBounds = VcsStructureChooser.this.myTree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                }
                return true;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath[] paths = VcsStructureChooser.this.myTree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    for (TreePath path : paths) {
                        if (path == null) continue;
                        Object o = path.getLastPathComponent();
                        if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                            return;
                        }
                        VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    }
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                    e.consume();
                }
            }
        });
        JBPanel panel2 = new JBPanel((LayoutManager)new BorderLayout());
        panel2.add((Component)new JBScrollPane((Component)fileSystemTree.getTree()), (Object)"Center");
        final JLabel selectedLabel = new JLabel("");
        selectedLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        panel2.add((Component)selectedLabel, (Object)"South");
        this.mySelectionManager.setSelectionChangeListener(new PlusMinus<VirtualFile>(){

            @Override
            public void plus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.add(virtualFile);
                this.recalculateErrorText();
            }

            private void recalculateErrorText() {
                VcsStructureChooser.this.checkEmpty();
                if (VcsStructureChooser.this.mySelectionManager.canAddSelection()) {
                    selectedLabel.setText("");
                } else {
                    selectedLabel.setText(VcsStructureChooser.CAN_NOT_ADD_TEXT);
                }
                selectedLabel.revalidate();
            }

            @Override
            public void minus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.remove(virtualFile);
                this.recalculateErrorText();
            }
        });
        panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        return panel2;
    }

    @NotNull
    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "getTreeRoot"));
        }
        return defaultMutableTreeNode;
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "getFile"));
        }
        if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)((DefaultMutableTreeNode)node).getUserObject());
        if (descriptor.getElement().getFile() == null) {
            return null;
        }
        return descriptor.getElement().getFile();
    }

    private static class WithModulesListCellRenderer
    extends VirtualFileListCellRenderer {
        @NotNull
        private final Map<VirtualFile, String> myModules;

        private WithModulesListCellRenderer(@NotNull Project project2, @NotNull Map<VirtualFile, String> modules) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "<init>"));
            }
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "<init>"));
            }
            super(project2, true);
            this.myModules = modules;
        }

        @Override
        protected String getName(@NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "getName"));
            }
            String module2 = this.myModules.get(path.getVirtualFile());
            if (module2 != null) {
                return module2;
            }
            return super.getName(path);
        }

        @Override
        protected void renderIcon(@NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "renderIcon"));
            }
            String module2 = this.myModules.get(path.getVirtualFile());
            if (module2 != null) {
                this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
            } else if (path.isDirectory()) {
                this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                this.setIcon(path.getFileType().getIcon());
            }
        }

        @Override
        protected void putParentPathImpl(@NotNull Object value2, @NotNull String parentPath, @NotNull FilePath self) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "putParentPathImpl"));
            }
            if (parentPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "putParentPathImpl"));
            }
            if (self == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "self", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer", "putParentPathImpl"));
            }
            this.append(self.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static class MyNodeConverter
    implements Convertor<DefaultMutableTreeNode, VirtualFile> {
        @NotNull
        private static final MyNodeConverter ourInstance = new MyNodeConverter();

        private MyNodeConverter() {
        }

        @NotNull
        public static MyNodeConverter getInstance() {
            MyNodeConverter myNodeConverter = ourInstance;
            if (myNodeConverter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyNodeConverter", "getInstance"));
            }
            return myNodeConverter;
        }

        public VirtualFile convert(DefaultMutableTreeNode o) {
            return ((FileNodeDescriptor)((Object)o.getUserObject())).getElement().getFile();
        }
    }

    private static class MyCheckboxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        @NotNull
        private final WithModulesListCellRenderer myTextRenderer;
        @NotNull
        public final JCheckBox myCheckbox;
        @NotNull
        private final SelectionManager mySelectionManager;
        @NotNull
        private final Map<VirtualFile, String> myModulesSet;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final ColoredTreeCellRenderer myColoredRenderer;
        @NotNull
        private final JLabel myEmpty;
        @NotNull
        private final JList myFictive;

        private MyCheckboxTreeCellRenderer(@NotNull SelectionManager selectionManager, @NotNull Map<VirtualFile, String> modulesSet, @NotNull Project project2, @NotNull JTree tree, @NotNull Collection<VirtualFile> roots) {
            if (selectionManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionManager", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer", "<init>"));
            }
            if (modulesSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesSet", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer", "<init>"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer", "<init>"));
            }
            super(new BorderLayout());
            this.mySelectionManager = selectionManager;
            this.myModulesSet = modulesSet;
            this.myRoots = roots;
            this.setBackground(tree.getBackground());
            this.myColoredRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (tree == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer$1", "customizeCellRenderer"));
                    }
                    this.append(value2.toString());
                }
            };
            this.myFictive = new JBList();
            this.myFictive.setBackground(tree.getBackground());
            this.myFictive.setSelectionBackground(UIUtil.getListSelectionBackground());
            this.myFictive.setSelectionForeground(UIUtil.getListSelectionForeground());
            this.myTextRenderer = new WithModulesListCellRenderer(project2, this.myModulesSet){

                @Override
                protected void putParentPath(Object value2, FilePath path, FilePath self) {
                    if (myRoots.contains(self.getVirtualFile())) {
                        super.putParentPath(value2, path, self);
                    }
                }
            };
            this.myTextRenderer.setBackground(tree.getBackground());
            this.myCheckbox = new JCheckBox();
            this.myCheckbox.setBackground(tree.getBackground());
            this.myEmpty = new JLabel("");
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.myCheckbox.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value2 == null) {
                return this.myEmpty;
            }
            VirtualFile file2 = VcsStructureChooser.getFile(value2);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            if (file2 == null) {
                Object uo = node.getUserObject();
                if (uo instanceof String) {
                    this.myColoredRenderer.getTreeCellRendererComponent(tree, (Object)node, selected, expanded, leaf, row, hasFocus);
                    return this.myColoredRenderer;
                }
                return this.myEmpty;
            }
            this.myCheckbox.setVisible(true);
            TreeNodeState state = this.mySelectionManager.getState(node);
            this.myCheckbox.setEnabled(TreeNodeState.CLEAR.equals((Object)state) || TreeNodeState.SELECTED.equals((Object)state));
            this.myCheckbox.setSelected(!TreeNodeState.CLEAR.equals((Object)state));
            this.myCheckbox.setOpaque(false);
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            this.myTextRenderer.getListCellRendererComponent(this.myFictive, file2, 0, selected, hasFocus);
            this.revalidate();
            return this;
        }
    }
}

