/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.CommitSelectionListenerForDiff;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myUi;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final JBLoadingPanel myChangesLoadingPane;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final RepositoryChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;

    public MainFrame(@NotNull VcsLogData logData, @NotNull VcsLogUiImpl ui, @NotNull Project project2, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLog log, @NotNull VisiblePack initialDataPack) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        this.myLogData = logData;
        this.myUi = ui;
        this.myLog = log;
        this.myUiProperties = uiProperties;
        this.myFilterUi = new VcsLogClassicFilterUi(ui, logData, this.myUiProperties, initialDataPack);
        this.myGraphTable = new VcsLogGraphTable(ui, logData, initialDataPack);
        this.myGraphTable.setCompactReferencesView(this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        this.myGraphTable.setShowTagNames(this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new DetailsPanel(logData, ui.getColorManager(), this);
        this.myChangesBrowser = new RepositoryChangesBrowser(project2, null, Collections.emptyList(), null){

            @Override
            protected void buildToolBar(DefaultActionGroup toolBarGroup) {
                super.buildToolBar(toolBarGroup);
                toolBarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.ShowDetailsAction"));
            }
        };
        this.myChangesBrowser.getViewerScrollPane().setBorder(IdeBorderFactory.createBorder((int)2));
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesBrowser.getEditSourceAction().registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesBrowser.getViewer().setEmptyText("");
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.details.splitter.proportion", 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)this.myChangesLoadingPane);
        this.setupDetailsSplitter(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myGraphTable.getSelectionModel().addListSelectionListener(new MyCommitSelectionListenerForDiff());
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        this.myTextFilter = this.myFilterUi.createTextFilter();
        this.myToolbar = this.createActionsToolbar();
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 2), this.myLogData, this), "Center");
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, "vcs.log.changes.splitter.proportion", 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myChangesBrowserSplitter);
        Disposer.register((Disposable)ui, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/MainFrame", "updateDataPack"));
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
    }

    public void setupDetailsSplitter(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getGraphTable"));
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogClassicFilterUi vcsLogClassicFilterUi = this.myFilterUi;
        if (vcsLogClassicFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getFilterUi"));
        }
        return vcsLogClassicFilterUi;
    }

    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.QuickTextFilterSettings"));
        mainGroup.add((AnAction)new Separator());
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        if (BekUtil.isBekEnabled()) {
            if (BekUtil.isLinearBekEnabled()) {
                mainGroup.add((AnAction)new IntelliSortChooserPopupAction());
            } else {
                mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"));
            }
        }
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper((JComponent)this.myTextFilter);
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        textFilter.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        ActionToolbar settings = this.createActionsToolbar(new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.QuickSettings")}));
        settings.setReservePlaceAutoPopupIcon(false);
        settings.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[right]", "center"));
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(settings.getComponent());
        return panel2;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        if (mainGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainGroup", "com/intellij/vcs/log/ui/frame/MainFrame", "createActionsToolbar"));
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "createActionsToolbar"));
        }
        return actionToolbar;
    }

    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this;
        if (mainFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getMainComponent"));
        }
        return mainFrame;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return ArrayUtil.toObjectArray(this.myChangesBrowser.getCurrentDisplayedChanges(), Change.class);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            List details = this.myLog.getSelectedDetails();
            if (details.size() > 1000) {
                return null;
            }
            return ContainerUtil.map2Array((Collection)details, CommittedChangeListForRevision.class, VcsLogUtil::createCommittedChangeList);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            Set<VirtualFile> roots = this.getSelectedRoots();
            if (roots == null) {
                return null;
            }
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(roots))).getSupportedVcs();
            }
        } else {
            if (VcsLogDataKeys.VCS_LOG_BRANCHES.is(dataId)) {
                int[] selectedRows = this.myGraphTable.getSelectedRows();
                if (selectedRows.length != 1) {
                    return null;
                }
                return this.myGraphTable.getModel().getBranchesAtRow(selectedRows[0]);
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return HELP_ID;
            }
            if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
                return this.myUiProperties;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                Collection roots = (Collection)ObjectUtils.chooseNotNull(this.getSelectedRoots(), VcsLogUtil.getVisibleRoots(this.myUi));
                return VfsUtilCore.toVirtualFileArray((Collection)roots);
            }
        }
        return null;
    }

    @Nullable
    private Set<VirtualFile> getSelectedRoots() {
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            return null;
        }
        return ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row -> this.myGraphTable.getModel().getRoot((int)row));
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getToolbar"));
        }
        return jComponent;
    }

    @NotNull
    public SearchTextField getTextFilter() {
        SearchTextField searchTextField = this.myTextFilter;
        if (searchTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getTextFilter"));
        }
        return searchTextField;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list2 = Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myTextFilter.getTextEditor()});
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
            }
            return list2;
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListenerForDiff {
        protected MyCommitSelectionListenerForDiff() {
            super(MainFrame.this.myLogData, MainFrame.this.myGraphTable);
        }

        @Override
        protected void onEmptySelection() {
            super.onEmptySelection();
            MainFrame.this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
        }

        @Override
        protected void setChangesToDisplay(@NotNull List<Change> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/vcs/log/ui/frame/MainFrame$MyCommitSelectionListenerForDiff", "setChangesToDisplay"));
            }
            MainFrame.this.myChangesBrowser.setChangesToDisplay(changes);
        }

        @Override
        protected void clearChanges() {
            MainFrame.this.myChangesBrowser.setChangesToDisplay(Collections.emptyList());
            MainFrame.this.myChangesBrowser.getViewer().setEmptyText("");
        }

        @Override
        protected void startLoading() {
            MainFrame.this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void stopLoading() {
            MainFrame.this.myChangesLoadingPane.stopLoading();
        }
    }
}

