/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StopWatch {
    private static final Logger LOG = Logger.getInstance(StopWatch.class);
    private static final String[] UNIT_NAMES = new String[]{"s", "m", "h"};
    private static final long[] UNITS = new long[]{1L, 60L, 3600L};
    private static final String MSEC_FORMAT = "%03d";
    private final long myStartTime;
    @NotNull
    private final String myOperation;
    @NotNull
    private final Map<VirtualFile, Long> myDurationPerRoot;

    private StopWatch(@NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/vcs/log/util/StopWatch", "<init>"));
        }
        this.myOperation = operation;
        this.myStartTime = System.currentTimeMillis();
        this.myDurationPerRoot = ContainerUtil.newHashMap();
    }

    @NotNull
    public static StopWatch start(@NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/vcs/log/util/StopWatch", "start"));
        }
        StopWatch stopWatch = new StopWatch(operation);
        if (stopWatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/StopWatch", "start"));
        }
        return stopWatch;
    }

    public void rootCompleted(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/util/StopWatch", "rootCompleted"));
        }
        long totalDuration = System.currentTimeMillis() - this.myStartTime;
        long duration = totalDuration - StopWatch.sum(this.myDurationPerRoot.values());
        this.myDurationPerRoot.put(root, duration);
    }

    private static long sum(@NotNull Collection<Long> durations) {
        if (durations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "durations", "com/intellij/vcs/log/util/StopWatch", "sum"));
        }
        long sum = 0L;
        for (Long duration : durations) {
            sum += duration.longValue();
        }
        return sum;
    }

    public void report() {
        String message2 = this.myOperation + " took " + StopWatch.formatTime(System.currentTimeMillis() - this.myStartTime);
        if (this.myDurationPerRoot.size() > 1) {
            message2 = message2 + "\n" + StringUtil.join(this.myDurationPerRoot.entrySet(), entry -> "    " + ((VirtualFile)entry.getKey()).getName() + ": " + StopWatch.formatTime((Long)entry.getValue()), (String)"\n");
        }
        LOG.debug(message2);
    }

    @NotNull
    public static String formatTime(long time) {
        if (time < 1000L * UNITS[0]) {
            String string = time + "ms";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/StopWatch", "formatTime"));
            }
            return string;
        }
        String result2 = "";
        long remainder = time / 1000L;
        long msec = time % 1000L;
        for (int i2 = UNITS.length - 1; i2 >= 0; --i2) {
            if (remainder < UNITS[i2]) continue;
            long quotient = remainder / UNITS[i2];
            remainder %= UNITS[i2];
            if (i2 == 0) {
                result2 = result2 + quotient + (msec == 0L ? "" : "." + String.format(MSEC_FORMAT, msec)) + UNIT_NAMES[i2];
                continue;
            }
            result2 = result2 + quotient + UNIT_NAMES[i2] + " ";
            if (remainder != 0L || msec == 0L) continue;
            result2 = result2 + "0." + String.format(MSEC_FORMAT, msec) + UNIT_NAMES[0];
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/StopWatch", "formatTime"));
        }
        return string;
    }
}

