/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class EditBreakpointActionHandler
extends DebuggerActionHandler {
    protected abstract void doShowPopup(Project var1, JComponent var2, Point var3, Object var4);

    @Override
    public void perform(@NotNull Project project2, AnActionEvent event) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "perform"));
        }
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        Pair<GutterIconRenderer, Object> pair2 = XBreakpointUtil.findSelectedBreakpoint(project2, editor);
        Object breakpoint = pair2.second;
        GutterIconRenderer breakpointGutterRenderer = (GutterIconRenderer)pair2.first;
        if (breakpointGutterRenderer == null) {
            return;
        }
        this.editBreakpoint(project2, editor, breakpoint, breakpointGutterRenderer);
    }

    public void editBreakpoint(@NotNull Project project2, @NotNull Editor editor, @NotNull Object breakpoint, @NotNull GutterIconRenderer breakpointGutterRenderer) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (breakpointGutterRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointGutterRenderer", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (BreakpointsDialogFactory.getInstance(project2).isBreakpointPopupShowing()) {
            return;
        }
        EditorGutterComponentEx gutterComponent = ((EditorEx)editor).getGutterComponentEx();
        Point point = gutterComponent.getCenterPoint(breakpointGutterRenderer);
        if (point != null) {
            this.doShowPopup(project2, gutterComponent, point, breakpoint);
        }
    }

    public void editBreakpoint(@NotNull Project project2, @NotNull JComponent parent, @NotNull Point whereToShow, @NotNull BreakpointItem breakpoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (whereToShow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whereToShow", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        this.doShowPopup(project2, parent, whereToShow, breakpoint.getBreakpoint());
    }
}

