/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        String selectedText;
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "perform"));
        }
        XDebuggerEditorsProvider editorsProvider = session2.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
            mode = evaluator.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        }
        Promise<String> expressionTextPromise = Promise.resolve((Object)selectedText);
        if (selectedText == null && editor != null) {
            expressionTextPromise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        EvaluationMode finalMode = mode;
        XValue value2 = XDebuggerTreeActionBase.getSelectedValue(dataContext);
        expressionTextPromise.done(expressionText -> {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$perform$3"));
            }
            if (expressionText == null && value2 != null) {
                value2.calculateEvaluationExpression().done(expression2 -> {
                    if (session2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$null$1"));
                    }
                    if (expression2 != null) {
                        AppUIUtil.invokeOnEdt(() -> {
                            if (session2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$null$0"));
                            }
                            XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, expression2);
                        });
                    }
                });
            } else {
                XExpressionImpl expression3 = XExpressionImpl.fromText(StringUtil.notNullize((String)expressionText), finalMode);
                AppUIUtil.invokeOnEdt(() -> {
                    if (session2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "lambda$null$2"));
                    }
                    XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, expression3);
                });
            }
        });
    }

    private static void showDialog(@NotNull XDebugSession session2, VirtualFile file2, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator, @NotNull XExpression expression2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "showDialog"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "showDialog"));
        }
        if (expression2.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file2 != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
            }
            expression2 = new XExpressionImpl(expression2.getExpression(), language, expression2.getCustomInfo(), expression2.getMode());
        }
        XSourcePosition position = stackFrame == null ? null : stackFrame.getSourcePosition();
        new XDebuggerEvaluationDialog(session2, editorsProvider, expression2, position, evaluator.isCodeFragmentEvaluationSupported()).show();
    }

    @NotNull
    public static Promise<String> getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project2, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (project2 == null || evaluator == null) {
            Promise promise2 = Promise.resolve(null);
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
            }
            return promise2;
        }
        Document document = editor.getDocument();
        Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(project2, document, editor.getCaretModel().getOffset(), true);
        Promise promise3 = expressionInfoPromise.then(expressionInfo -> XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, document));
        if (promise3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        return promise3;
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text2 = expressionInfo.getExpressionText();
        return text2 == null ? document.getText(expressionInfo.getTextRange()) : text2;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getDisplayText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text2 = expressionInfo.getDisplayText();
        return text2 == null ? document.getText(expressionInfo.getTextRange()) : text2;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "isEnabled"));
        }
        return session2.getDebugProcess().getEvaluator() != null;
    }
}

