/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointGroupingByTypeRule;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointPanelProvider
extends BreakpointPanelProvider<XBreakpoint> {
    private final List<MyXBreakpointListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public void createBreakpointsGroupingRules(Collection<XBreakpointGroupingRule> rules) {
        rules.add(new XBreakpointGroupingByTypeRule());
        rules.add(new XBreakpointFileGroupingRule());
        rules.add(new XBreakpointCustomGroupingRule());
    }

    @Override
    public void addListener(final BreakpointPanelProvider.BreakpointsListener listener2, Project project2, Disposable disposable) {
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        MyXBreakpointListener listener1 = new MyXBreakpointListener(listener2, breakpointManager);
        breakpointManager.addBreakpointListener((XBreakpointListener)listener1);
        this.myListeners.add(listener1);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                XBreakpointPanelProvider.this.removeListener(listener2);
            }
        });
    }

    @Override
    protected void removeListener(BreakpointPanelProvider.BreakpointsListener listener2) {
        for (MyXBreakpointListener breakpointListener : this.myListeners) {
            if (breakpointListener.myListener != listener2) continue;
            XBreakpointManager manager = breakpointListener.myBreakpointManager;
            manager.removeBreakpointListener((XBreakpointListener)breakpointListener);
            this.myListeners.remove(breakpointListener);
            break;
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @Nullable
    public XBreakpoint<?> findBreakpoint(@NotNull Project project2, @NotNull Document document, int offset) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider", "findBreakpoint"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider", "findBreakpoint"));
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        int line = document.getLineNumber(offset);
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return null;
        }
        for (XLineBreakpointType type2 : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type2, file2, line);
            if (breakpoint == null) continue;
            return breakpoint;
        }
        return null;
    }

    @Override
    public GutterIconRenderer getBreakpointGutterIconRenderer(Object breakpoint) {
        RangeHighlighter highlighter;
        if (breakpoint instanceof XLineBreakpointImpl && (highlighter = ((XLineBreakpointImpl)breakpoint).getHighlighter()) != null) {
            return highlighter.getGutterIconRenderer();
        }
        return null;
    }

    @Override
    public void onDialogClosed(Project project2) {
    }

    @Override
    public void provideBreakpointItems(Project project2, Collection<BreakpointItem> items) {
        Arrays.stream(XDebuggerManager.getInstance((Project)project2).getBreakpointManager().getAllBreakpoints()).map(XBreakpointItem::new).forEach(items::add);
    }

    private static class AddXBreakpointAction
    extends AnAction {
        private final XBreakpointType<?, ?> myType;

        public AddXBreakpointAction(XBreakpointType<?, ?> type2) {
            this.myType = type2;
            this.getTemplatePresentation().setIcon(type2.getEnabledIcon());
            this.getTemplatePresentation().setText(type2.getTitle());
        }

        public void actionPerformed(AnActionEvent e) {
            this.myType.addBreakpoint(AddXBreakpointAction.getEventProject((AnActionEvent)e), null);
        }
    }

    private static class MyXBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        public final BreakpointPanelProvider.BreakpointsListener myListener;
        public final XBreakpointManager myBreakpointManager;

        public MyXBreakpointListener(BreakpointPanelProvider.BreakpointsListener listener2, XBreakpointManager breakpointManager) {
            this.myListener = listener2;
            this.myBreakpointManager = breakpointManager;
        }

        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider$MyXBreakpointListener", "breakpointAdded"));
            }
            this.myListener.breakpointsChanged();
        }

        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider$MyXBreakpointListener", "breakpointRemoved"));
            }
            this.myListener.breakpointsChanged();
        }

        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider$MyXBreakpointListener", "breakpointChanged"));
            }
            this.myListener.breakpointsChanged();
        }
    }
}

