/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValuePresentationUtil {
    public static void renderValue(@NotNull String value2, @NotNull ColoredTextContainer text2, @NotNull SimpleTextAttributes attributes, int maxLength, @Nullable String additionalCharsToEscape) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "renderValue"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "renderValue"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "renderValue"));
        }
        SimpleTextAttributes escapeAttributes = null;
        int lastOffset = 0;
        int length = maxLength == -1 ? value2.length() : Math.min(value2.length(), maxLength);
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = value2.charAt(i2);
            int additionalCharIndex = -1;
            if (ch != '\n' && ch != '\r' && ch != '\t' && ch != '\b' && ch != '\f' && (additionalCharsToEscape == null || (additionalCharIndex = additionalCharsToEscape.indexOf(ch)) == -1)) continue;
            if (i2 > lastOffset) {
                text2.append(value2.substring(lastOffset, i2), attributes);
            }
            lastOffset = i2 + 1;
            if (escapeAttributes == null) {
                TextAttributes fromHighlighter = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
                escapeAttributes = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)fromHighlighter) : new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            }
            if (additionalCharIndex == -1) {
                text2.append("\\", escapeAttributes);
            }
            text2.append(String.valueOf(XValuePresentationUtil.getEscapingSymbol(ch)), escapeAttributes);
        }
        if (lastOffset < length) {
            text2.append(value2.substring(lastOffset, length), attributes);
        }
    }

    private static char getEscapingSymbol(char ch) {
        switch (ch) {
            case '\n': {
                return 'n';
            }
            case '\r': {
                return 'r';
            }
            case '\t': {
                return 't';
            }
            case '\b': {
                return 'b';
            }
            case '\f': {
                return 'f';
            }
        }
        return ch;
    }

    public static void appendSeparator(@NotNull ColoredTextContainer text2, @NotNull String separator) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "appendSeparator"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "appendSeparator"));
        }
        if (!separator.isEmpty()) {
            text2.append(separator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public static String computeValueText(@NotNull XValuePresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "computeValueText"));
        }
        XValuePresentationTextExtractor extractor = new XValuePresentationTextExtractor();
        presentation.renderValue((XValuePresentation.XValueTextRenderer)extractor);
        String string = extractor.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil", "computeValueText"));
        }
        return string;
    }

    private static class XValuePresentationTextExtractor
    extends XValueTextRendererBase {
        private final StringBuilder myBuilder = new StringBuilder();

        public void renderValue(@NotNull String value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderValue"));
            }
            this.myBuilder.append(value2);
        }

        @Override
        protected void renderRawValue(@NotNull String value2, @NotNull TextAttributesKey key2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderRawValue"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderRawValue"));
            }
            this.myBuilder.append(value2);
        }

        public void renderStringValue(@NotNull String value2, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderStringValue"));
            }
            this.myBuilder.append(value2);
        }

        public void renderComment(@NotNull String comment) {
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderComment"));
            }
            this.myBuilder.append(comment);
        }

        public void renderError(@NotNull String error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderError"));
            }
            this.myBuilder.append(error);
        }

        public void renderSpecialSymbol(@NotNull String symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor", "renderSpecialSymbol"));
            }
            this.myBuilder.append(symbol);
        }

        public String getText() {
            return this.myBuilder.toString();
        }
    }
}

