/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlExtension {
    public static final ExtensionPointName<XmlExtension> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlExtension");

    public static XmlExtension getExtension(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlExtension", "getExtension"));
        }
        return (XmlExtension)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlExtension", "lambda$getExtension$0"));
            }
            return CachedValueProvider.Result.create((Object)XmlExtension.calcExtension(file2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static XmlExtension calcExtension(PsiFile file2) {
        for (XmlExtension extension : (XmlExtension[])Extensions.getExtensions(EP_NAME)) {
            if (!extension.isAvailable(file2)) continue;
            return extension;
        }
        return DefaultXmlExtension.DEFAULT_EXTENSION;
    }

    public static XmlExtension getExtensionByElement(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            return XmlExtension.getExtension(psiFile);
        }
        return null;
    }

    public abstract boolean isAvailable(PsiFile var1);

    @NotNull
    public abstract List<TagInfo> getAvailableTagNames(@NotNull XmlFile var1, @NotNull XmlTag var2);

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag);
    }

    @Nullable
    public String[][] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        return declarationsExist ? (String[][])null : XmlUtil.getDefaultNamespaces(parent);
    }

    public boolean canBeDuplicated(XmlAttribute attribute) {
        return false;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        return false;
    }

    public HighlightInfoType getHighlightInfoType(XmlFile file2) {
        return HighlightInfoType.ERROR;
    }

    @Nullable
    public abstract SchemaPrefix getPrefixDeclaration(XmlTag var1, String var2);

    public SearchScope getNsPrefixScope(XmlAttribute declaration2) {
        return new LocalSearchScope((PsiElement)declaration2.getParent());
    }

    public boolean shouldBeHighlightedAsTag(XmlTag tag) {
        return true;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag tag, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        return parentDescriptor.getElementDescriptor(tag, contextTag);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        return element.getNSDescriptor(namespace, strict);
    }

    @Nullable
    public XmlTag getParentTagForNamespace(XmlTag tag, XmlNSDescriptor namespace) {
        return tag.getParentTag();
    }

    @Nullable
    public XmlFile getContainingFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile containingFile, XmlNSDescriptor descr) {
        return descr;
    }

    public boolean hasDynamicComponents(PsiElement element) {
        return false;
    }

    public boolean isIndirectSyntax(XmlAttributeDescriptor descriptor) {
        return false;
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor) {
        return descriptor.isRequired();
    }

    public AttributeValuePresentation getAttributeValuePresentation(@NotNull XmlAttributeDescriptor descriptor, final @NotNull String defaultAttributeQuote) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/XmlExtension", "getAttributeValuePresentation"));
        }
        if (defaultAttributeQuote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAttributeQuote", "com/intellij/xml/XmlExtension", "getAttributeValuePresentation"));
        }
        return new AttributeValuePresentation(){

            @Override
            @NotNull
            public String getPrefix() {
                String string = defaultAttributeQuote;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/XmlExtension$1", "getPrefix"));
                }
                return string;
            }

            @Override
            @NotNull
            public String getPostfix() {
                String string = defaultAttributeQuote;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/XmlExtension$1", "getPostfix"));
                }
                return string;
            }
        };
    }

    public boolean isCustomTagAllowed(XmlTag tag) {
        return false;
    }

    public boolean useXmlTagInsertHandler() {
        return true;
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        return false;
    }

    public static class TagInfo {
        public final String name;
        public final String namespace;

        public TagInfo(String name2, String namespace) {
            this.name = name2;
            this.namespace = namespace;
        }

        @Nullable
        public PsiElement getDeclaration() {
            return null;
        }
    }

    public static interface AttributeValuePresentation {
        @NotNull
        public String getPrefix();

        @NotNull
        public String getPostfix();
    }
}

