/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlBraceMatcher
implements XmlAwareBraceMatcher {
    private static final int XML_TAG_TOKEN_GROUP = 1;
    private static final int XML_VALUE_DELIMITER_GROUP = 2;
    private static final BidirectionalMap<IElementType, IElementType> PAIRING_TOKENS = new BidirectionalMap();

    @Override
    public int getBraceTokenGroupId(IElementType tokenType) {
        Language l = tokenType.getLanguage();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(l);
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair2 : pairs = matcher.getPairs()) {
                if (pair2.getLeftBraceType() != tokenType && pair2.getRightBraceType() != tokenType) continue;
                return l.hashCode();
            }
        }
        if (tokenType instanceof IXmlLeafElementType) {
            return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? 2 : 1;
        }
        return -1;
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair2 : pairs = matcher.getPairs()) {
                if (pair2.getLeftBraceType() != tokenType) continue;
                return true;
            }
        }
        return tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || tokenType == XmlTokenType.XML_CDATA_START;
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair2 : pairs = matcher.getPairs()) {
                if (pair2.getRightBraceType() != tokenType) continue;
                return true;
            }
        }
        if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER || tokenType == XmlTokenType.XML_CDATA_END) {
            return true;
        }
        if (tokenType == XmlTokenType.XML_TAG_END) {
            String tagName;
            boolean result2 = XmlBraceMatcher.findEndTagStart(iterator);
            if (this.isFileTypeWithSingleHtmlTags(fileType) && (tagName = this.getTagName(fileText, iterator)) != null && HtmlUtil.isSingleHtmlTag(tagName)) {
                return !result2;
            }
            return result2;
        }
        return false;
    }

    protected boolean isFileTypeWithSingleHtmlTags(FileType fileType) {
        return fileType == StdFileTypes.HTML;
    }

    @Override
    public boolean isPairBraces(IElementType tokenType1, IElementType tokenType2) {
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType1.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair2 : pairs = matcher.getPairs()) {
                if (pair2.getLeftBraceType() == tokenType1) {
                    return pair2.getRightBraceType() == tokenType2;
                }
                if (pair2.getRightBraceType() != tokenType1) continue;
                return pair2.getLeftBraceType() == tokenType2;
            }
        }
        if (tokenType2.equals(PAIRING_TOKENS.get((Object)tokenType1))) {
            return true;
        }
        List keys = PAIRING_TOKENS.getKeysByValue((Object)tokenType1);
        return keys != null && keys.contains(tokenType2);
    }

    @Override
    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text2, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair2 : pairs = matcher.getPairs()) {
                if (pair2.getLeftBraceType() != tokenType && pair2.getRightBraceType() != tokenType || !pair2.isStructural()) continue;
                return true;
            }
        }
        if (fileType instanceof XmlLikeFileType) {
            return this.isXmlStructuralBrace(iterator, text2, fileType, tokenType);
        }
        return false;
    }

    protected boolean isXmlStructuralBrace(HighlighterIterator iterator, CharSequence text2, FileType fileType, IElementType tokenType) {
        return tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END || tokenType == XmlTokenType.XML_TAG_END && this.isFileTypeWithSingleHtmlTags(fileType) && this.isEndOfSingleHtmlTag(text2, iterator);
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/xml/impl/XmlBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return true;
    }

    @Override
    public boolean isStrictTagMatching(FileType fileType, int braceGroupId) {
        switch (braceGroupId) {
            case 1: {
                return this.isStrictTagMatchingForFileType(fileType);
            }
        }
        return false;
    }

    protected boolean isStrictTagMatchingForFileType(FileType fileType) {
        return fileType == StdFileTypes.XML || fileType == StdFileTypes.XHTML;
    }

    @Override
    public boolean areTagsCaseSensitive(FileType fileType, int braceGroupId) {
        switch (braceGroupId) {
            case 1: {
                return fileType == StdFileTypes.XML;
            }
        }
        return false;
    }

    private static boolean findEndTagStart(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        int balance = 0;
        int count = 0;
        while (balance >= 0) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            tokenType = iterator.getTokenType();
            if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                ++balance;
                continue;
            }
            if (tokenType != XmlTokenType.XML_END_TAG_START && tokenType != XmlTokenType.XML_START_TAG_START) continue;
            --balance;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return tokenType == XmlTokenType.XML_END_TAG_START;
    }

    private boolean isEndOfSingleHtmlTag(CharSequence text2, HighlighterIterator iterator) {
        String tagName = this.getTagName(text2, iterator);
        return tagName != null && HtmlUtil.isSingleHtmlTag(tagName);
    }

    @Override
    public String getTagName(CharSequence fileText, HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        String name2 = null;
        if (tokenType == XmlTokenType.XML_START_TAG_START) {
            iterator.advance();
            IElementType tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            boolean wasWhiteSpace = false;
            if (this.isWhitespace(tokenType1)) {
                wasWhiteSpace = true;
                iterator.advance();
                IElementType iElementType = tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            }
            if (tokenType1 == XmlTokenType.XML_TAG_NAME || tokenType1 == XmlTokenType.XML_NAME) {
                name2 = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            if (wasWhiteSpace) {
                iterator.retreat();
            }
            iterator.retreat();
        } else if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            int balance = 0;
            int count = 0;
            IElementType tokenType1 = iterator.getTokenType();
            while (balance >= 0) {
                iterator.retreat();
                ++count;
                if (iterator.atEnd()) break;
                tokenType1 = iterator.getTokenType();
                if (tokenType1 == XmlTokenType.XML_TAG_END || tokenType1 == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    ++balance;
                    continue;
                }
                if (tokenType1 != XmlTokenType.XML_TAG_NAME) continue;
                --balance;
            }
            if (tokenType1 == XmlTokenType.XML_TAG_NAME) {
                name2 = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            while (count-- > 0) {
                iterator.advance();
            }
        }
        return name2;
    }

    protected boolean isWhitespace(IElementType tokenType1) {
        return tokenType1 == TokenType.WHITE_SPACE;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xml/impl/XmlBraceMatcher", "getOppositeBraceTokenType"));
        }
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(type2.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair2 : pairs = matcher.getPairs()) {
                if (pair2.getLeftBraceType() == type2) {
                    return pair2.getRightBraceType();
                }
                if (pair2.getRightBraceType() != type2) continue;
                return pair2.getLeftBraceType();
            }
        }
        return null;
    }

    @Override
    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return openingBraceOffset;
    }

    static {
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_TAG_END, (Object)XmlTokenType.XML_START_TAG_START);
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_CDATA_START, (Object)XmlTokenType.XML_CDATA_END);
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_EMPTY_ELEMENT_END, (Object)XmlTokenType.XML_START_TAG_START);
        PAIRING_TOKENS.put((Object)XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER);
    }
}

