/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public static final Topic<Runnable> JSON_SCHEMA_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Schema.Changed", Runnable.class);

    public static void startListening(@NotNull Project project2, @NotNull JsonSchemaService service) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaVfsListener", "startListening"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/jetbrains/jsonSchema/JsonSchemaVfsListener", "startListening"));
        }
        final MyUpdater updater = new MyUpdater(project2, service);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project2).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(updater));
        PsiManager.getInstance((Project)project2).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file2) {
                if (file2 != null) {
                    updater.onFileChange(file2.getViewProvider().getVirtualFile());
                }
            }
        });
    }

    private JsonSchemaVfsListener(final @NotNull MyUpdater updater) {
        if (updater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/jetbrains/jsonSchema/JsonSchemaVfsListener", "<init>"));
        }
        super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){
            private final MyUpdater myUpdater;
            {
                this.myUpdater = updater;
            }

            protected void onFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$2", "onFileChange"));
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$2", "onBeforeFileChange"));
                }
                this.myUpdater.onFileChange(schemaFile);
            }
        });
    }

    private static class MyUpdater {
        @NotNull
        private final Project myProject;
        private final ZipperUpdater myUpdater;
        @NotNull
        private final JsonSchemaService myService;
        private final Set<VirtualFile> myDirtySchemas;
        private final Runnable myRunnable;

        protected MyUpdater(@NotNull Project project2, @NotNull JsonSchemaService service) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$MyUpdater", "<init>"));
            }
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$MyUpdater", "<init>"));
            }
            this.myDirtySchemas = ContainerUtil.newConcurrentSet();
            this.myProject = project2;
            this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
            this.myService = service;
            this.myRunnable = () -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$MyUpdater", "lambda$new$5"));
                }
                HashSet<VirtualFile> scope = new HashSet<VirtualFile>(this.myDirtySchemas);
                this.myDirtySchemas.removeAll(scope);
                if (scope.isEmpty()) {
                    return;
                }
                DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
                PsiManager psiManager = PsiManager.getInstance((Project)project2);
                Editor[] editors = EditorFactory.getInstance().getAllEditors();
                Arrays.stream(editors).filter(editor -> editor instanceof EditorEx).map(editor -> ((EditorEx)editor).getVirtualFile()).filter(file2 -> file2 != null && file2.isValid()).forEach(file2 -> {
                    Collection<VirtualFile> schemaFiles = this.myService.getSchemaFilesForFile((VirtualFile)file2);
                    if (schemaFiles.stream().anyMatch(scope::contains)) {
                        ReadAction.run(() -> Optional.ofNullable(psiManager.findFile(file2)).ifPresent(arg_0 -> ((DaemonCodeAnalyzer)analyzer).restart(arg_0)));
                    }
                });
            };
        }

        protected void onFileChange(@NotNull VirtualFile schemaFile) {
            if (schemaFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/JsonSchemaVfsListener$MyUpdater", "onFileChange"));
            }
            if (this.myService.isSchemaFile(schemaFile)) {
                ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_SCHEMA_CHANGED)).run();
                this.myDirtySchemas.add(schemaFile);
                this.myUpdater.queue(this.myRunnable);
            }
        }
    }
}

