/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="SchemaInfo")
public class UserDefinedJsonSchemaConfiguration {
    private static final Comparator<Item> ITEM_COMPARATOR = (o1, o2) -> {
        if (o1.pattern != o2.pattern) {
            return o1.pattern ? -1 : 1;
        }
        if (o1.directory != o2.directory) {
            return o1.directory ? -1 : 1;
        }
        return o1.path.compareToIgnoreCase(o2.path);
    };
    public String name;
    public String relativePathToSchema;
    public boolean applicationLevel;
    public List<Item> patterns;
    @Transient
    private final AtomicClearableLazyValue<List<PairProcessor<Project, VirtualFile>>> myCalculatedPatterns;

    public UserDefinedJsonSchemaConfiguration() {
        this.patterns = new SmartList();
        this.myCalculatedPatterns = new AtomicClearableLazyValue<List<PairProcessor<Project, VirtualFile>>>(){

            @NotNull
            protected List<PairProcessor<Project, VirtualFile>> compute() {
                List list2 = UserDefinedJsonSchemaConfiguration.this.recalculatePatterns();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$1", "compute"));
                }
                return list2;
            }
        };
    }

    public UserDefinedJsonSchemaConfiguration(@NotNull String name2, @NotNull String relativePathToSchema, boolean applicationLevel, @Nullable List<Item> patterns) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration", "<init>"));
        }
        if (relativePathToSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePathToSchema", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration", "<init>"));
        }
        this.patterns = new SmartList();
        this.myCalculatedPatterns = new /* invalid duplicate definition of identical inner class */;
        this.name = name2;
        this.relativePathToSchema = relativePathToSchema;
        this.applicationLevel = applicationLevel;
        this.setPatterns(patterns);
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration", "setName"));
        }
        this.name = name2;
    }

    public String getRelativePathToSchema() {
        return this.relativePathToSchema;
    }

    public void setRelativePathToSchema(String relativePathToSchema) {
        this.relativePathToSchema = relativePathToSchema;
    }

    public boolean isApplicationLevel() {
        return this.applicationLevel;
    }

    public void setApplicationLevel(boolean applicationLevel) {
        this.applicationLevel = applicationLevel;
    }

    public List<Item> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(@Nullable List<Item> patterns) {
        this.patterns.clear();
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        Collections.sort(this.patterns, ITEM_COMPARATOR);
        this.myCalculatedPatterns.drop();
    }

    @NotNull
    public List<PairProcessor<Project, VirtualFile>> getCalculatedPatterns() {
        List list2 = (List)this.myCalculatedPatterns.getValue();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration", "getCalculatedPatterns"));
        }
        return list2;
    }

    private List<PairProcessor<Project, VirtualFile>> recalculatePatterns() {
        SmartList result2 = new SmartList();
        for (final Item pattern : this.patterns) {
            if (pattern.pattern) {
                result2.add(new PairProcessor<Project, VirtualFile>(){
                    private final Matcher matcher;
                    {
                        this.matcher = PatternUtil.fromMask((String)pattern.path).matcher("");
                    }

                    public boolean process(Project project2, VirtualFile file2) {
                        this.matcher.reset(file2.getName());
                        return this.matcher.matches();
                    }
                });
                continue;
            }
            if (pattern.directory) {
                result2.add((project2, vfile) -> {
                    VirtualFile relativeFile = UserDefinedJsonSchemaConfiguration.getRelativeFile(project2, pattern);
                    return relativeFile != null && VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)vfile, (boolean)true);
                });
                continue;
            }
            result2.add((project2, vfile) -> vfile.equals(UserDefinedJsonSchemaConfiguration.getRelativeFile(project2, pattern)));
        }
        return result2;
    }

    @Nullable
    private static VirtualFile getRelativeFile(@NotNull Project project2, @NotNull Item pattern) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration", "getRelativeFile"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration", "getRelativeFile"));
        }
        if (project2.getBasePath() == null) {
            return null;
        }
        String path = FileUtilRt.toSystemIndependentName((String)StringUtil.notNullize((String)pattern.path));
        List parts = ContainerUtil.filter((Collection)StringUtil.split((String)path, (String)"/"), s -> !".".equals(s));
        if (parts.isEmpty()) {
            return project2.getBaseDir();
        }
        return VfsUtil.findRelativeFile((VirtualFile)project2.getBaseDir(), (String[])ArrayUtil.toStringArray((Collection)parts));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedJsonSchemaConfiguration info = (UserDefinedJsonSchemaConfiguration)o;
        if (this.applicationLevel != info.applicationLevel) {
            return false;
        }
        if (this.name != null ? !this.name.equals(info.name) : info.name != null) {
            return false;
        }
        if (this.relativePathToSchema != null ? !this.relativePathToSchema.equals(info.relativePathToSchema) : info.relativePathToSchema != null) {
            return false;
        }
        return !(this.patterns != null ? !this.patterns.equals(info.patterns) : info.patterns != null);
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.relativePathToSchema != null ? this.relativePathToSchema.hashCode() : 0);
        result2 = 31 * result2 + (this.applicationLevel ? 1 : 0);
        result2 = 31 * result2 + (this.patterns != null ? this.patterns.hashCode() : 0);
        return result2;
    }

    public static class Item {
        public String path;
        public boolean pattern;
        public boolean directory;

        public Item() {
        }

        public Item(String path, boolean isPattern, boolean isDirectory) {
            this.path = path;
            this.pattern = isPattern;
            this.directory = isDirectory;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isPattern() {
            return this.pattern;
        }

        public void setPattern(boolean pattern) {
            this.pattern = pattern;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public void setDirectory(boolean directory) {
            this.directory = directory;
        }

        public String getPresentation() {
            String prefix = this.pattern ? "Pattern: " : (this.directory ? "Directory: " : "File: ");
            return prefix + this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.pattern != item.pattern) {
                return false;
            }
            if (this.directory != item.directory) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(item.path) : item.path != null);
        }

        public int hashCode() {
            int result2 = this.path != null ? this.path.hashCode() : 0;
            result2 = 31 * result2 + (this.pattern ? 1 : 0);
            result2 = 31 * result2 + (this.directory ? 1 : 0);
            return result2;
        }
    }
}

