/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalkerFactory;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker JSON_ORIGINAL_PSI_WALKER = new JsonOriginalPsiWalker();

    public boolean isName(PsiElement var1);

    public boolean isPropertyWithValue(@NotNull PsiElement var1);

    public PsiElement goUpToCheckable(@NotNull PsiElement var1);

    public List<JsonSchemaVariantsTreeBuilder.Step> findPosition(@NotNull PsiElement var1, boolean var2, boolean var3);

    public boolean isNameQuoted();

    public boolean onlyDoubleQuotesForStringLiterals();

    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement var1);

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement var1);

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement var1);

    public boolean isTopJsonElement(@NotNull PsiElement var1);

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement var1);

    public static JsonLikePsiWalker getWalker(@NotNull PsiElement element, JsonSchemaObject schemaObject) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker", "getWalker"));
        }
        if (JSON_ORIGINAL_PSI_WALKER.handles(element)) {
            return JSON_ORIGINAL_PSI_WALKER;
        }
        return Arrays.stream(Extensions.getExtensions(JsonLikePsiWalkerFactory.EXTENSION_POINT_NAME)).filter(extension -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker", "lambda$getWalker$0"));
            }
            return extension.handles(element);
        }).findFirst().map(extension -> extension.create(schemaObject)).orElse(null);
    }
}

