/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaResolver {
    @NotNull
    private final JsonSchemaObject mySchema;
    private final boolean myIsName;
    @NotNull
    private final List<JsonSchemaVariantsTreeBuilder.Step> myPosition;

    public JsonSchemaResolver(@NotNull JsonSchemaObject schema, boolean isName, @NotNull List<JsonSchemaVariantsTreeBuilder.Step> position) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaResolver", "<init>"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaResolver", "<init>"));
        }
        this.mySchema = schema;
        this.myIsName = isName;
        this.myPosition = position;
    }

    public JsonSchemaResolver(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaResolver", "<init>"));
        }
        this.mySchema = schema;
        this.myIsName = true;
        this.myPosition = Collections.emptyList();
    }

    public MatchResult detailedResolve() {
        return this.detailedResolve(false, false, false);
    }

    private MatchResult detailedResolve(boolean skipLastExpand, boolean literalResolve, boolean acceptAdditionalPropertiesSchema) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.mySchema, this.myPosition, skipLastExpand, literalResolve, acceptAdditionalPropertiesSchema || !this.myIsName);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        Collection<JsonSchemaObject> collection = this.resolve(false, false, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaResolver", "resolve"));
        }
        return collection;
    }

    private Collection<JsonSchemaObject> resolve(boolean skipLastExpand, boolean literalResolve, boolean acceptAdditionalPropertiesSchema) {
        MatchResult result2 = this.detailedResolve(skipLastExpand, literalResolve, acceptAdditionalPropertiesSchema);
        HashSet<JsonSchemaObject> set2 = new HashSet<JsonSchemaObject>(result2.mySchemas);
        set2.addAll(result2.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        return set2;
    }

    @Nullable
    public PsiElement findNavigationTarget(boolean literalResolve, boolean acceptAdditionalPropertiesSchema) {
        Collection<JsonSchemaObject> schemas = this.resolve(true, literalResolve, acceptAdditionalPropertiesSchema);
        return schemas.stream().filter(schema -> schema.getJsonObject().isValid()).findFirst().map(schema -> {
            JsonObject jsonObject = schema.getJsonObject();
            if (jsonObject.getParent() instanceof JsonProperty) {
                return ((JsonProperty)jsonObject.getParent()).getNameElement();
            }
            return jsonObject;
        }).orElse(null);
    }
}

