/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    @NotNull
    private final Project myProject;
    private final MyState myState;
    private final AtomicLong myModificationCount;
    private final AtomicLong myAnyChangeCount;
    private final ModificationTracker myModificationTracker;
    private final ModificationTracker myAnySchemaChangeTracker;

    public JsonSchemaServiceImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "<init>"));
        }
        this.myModificationCount = new AtomicLong(0L);
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myProject = project2;
        this.myState = new MyState(() -> this.getProvidersFromFactories(factory -> factory.getProviders(this.myProject)));
        this.myModificationTracker = () -> this.myModificationCount.get();
        this.myAnySchemaChangeTracker = () -> this.myAnyChangeCount.get();
        project2.getMessageBus().connect().subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        JsonSchemaVfsListener.startListening(project2, this);
    }

    @Override
    public ModificationTracker getAnySchemaChangeTracker() {
        return this.myAnySchemaChangeTracker;
    }

    private List<JsonSchemaFileProvider> getProvidersFromFactories(@NotNull Function<JsonSchemaProviderFactory, List<JsonSchemaFileProvider>> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getProvidersFromFactories"));
        }
        return Arrays.stream(this.getProviderFactories()).map(function).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        JsonSchemaProviderFactory[] jsonSchemaProviderFactoryArray = (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
        if (jsonSchemaProviderFactoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getProviderFactories"));
        }
        return jsonSchemaProviderFactoryArray;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaProvider"));
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    public void reset() {
        this.myAnyChangeCount.incrementAndGet();
        this.myState.reset();
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> FileTypeManagerEx.getInstanceEx().fireFileTypesChanged()), ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "findSchemaFileByReference"));
        }
        Optional<VirtualFile> optional = this.myState.getFiles().stream().filter(file2 -> {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$findSchemaFileByReference$6"));
            }
            return reference.equals(JsonSchemaReader.readSchemaId(this.myProject, file2));
        }).findFirst();
        return optional.orElseGet(() -> {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$findSchemaFileByReference$7"));
            }
            return JsonSchemaServiceImpl.getSchemaFileByRefAsLocalFile(reference, referent);
        });
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaFilesForFile"));
        }
        Collection collection = this.myState.getProviders().stream().filter(provider -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$getSchemaFilesForFile$8"));
            }
            return this.isProviderAvailable(file2, (JsonSchemaFileProvider)provider);
        }).map(processor2 -> processor2.getSchemaFile()).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaFilesForFile"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider selected;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaObject"));
        }
        List providers2 = this.myState.getProviders().stream().filter(provider -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "lambda$getSchemaObject$10"));
            }
            return this.isProviderAvailable(file2, (JsonSchemaFileProvider)provider);
        }).collect(Collectors.toList());
        if (providers2.isEmpty() || providers2.size() > 2) {
            return null;
        }
        if (providers2.size() > 1) {
            Optional<JsonSchemaFileProvider> userSchema = providers2.stream().filter(provider -> SchemaType.userSchema.equals((Object)provider.getSchemaType())).findFirst();
            if (!userSchema.isPresent()) {
                return null;
            }
            selected = userSchema.get();
        } else {
            selected = (JsonSchemaFileProvider)providers2.get(0);
        }
        if (selected.getSchemaFile() == null) {
            return null;
        }
        return this.readCachedObject(selected.getSchemaFile());
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaObjectForSchemaFile"));
        }
        return this.readCachedObject(schemaFile);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isSchemaFile"));
        }
        return this.myState.getFiles().contains(file2);
    }

    @Nullable
    private JsonSchemaObject readCachedObject(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "readCachedObject"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(schemaFile);
        if (psiFile == null || !(psiFile instanceof JsonFile)) {
            return null;
        }
        CachedValueProvider provider = () -> {
            JsonObject topLevelValue = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class);
            JsonSchemaObject object = topLevelValue == null ? null : new JsonSchemaReader().read(topLevelValue);
            return CachedValueProvider.Result.create((Object)object, (Object[])new Object[]{psiFile, this.myModificationTracker});
        };
        return (JsonSchemaObject)ReadAction.compute(() -> (JsonSchemaObject)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider));
    }

    private boolean isProviderAvailable(@NotNull VirtualFile file2, @NotNull JsonSchemaFileProvider provider) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isProviderAvailable"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isProviderAvailable"));
        }
        FileType type2 = file2.getFileType();
        boolean isJson = type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE);
        return (isJson || !SchemaType.userSchema.equals((Object)provider.getSchemaType())) && provider.isAvailable(this.myProject, file2);
    }

    @Nullable
    private static VirtualFile getSchemaFileByRefAsLocalFile(@NotNull String id, @Nullable VirtualFile referent) {
        VirtualFile dir;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getSchemaFileByRefAsLocalFile"));
        }
        String normalizedId = JsonSchemaService.normalizeId(id);
        if (FileUtil.isAbsolute((String)normalizedId) || referent == null) {
            return VfsUtil.findFileByIoFile((File)new File(normalizedId), (boolean)false);
        }
        VirtualFile virtualFile = dir = referent.isDirectory() ? referent : referent.getParent();
        if (dir != null && dir.isValid()) {
            List parts = StringUtil.split((String)normalizedId.replace("\\", "/"), (String)"/");
            return VfsUtil.findRelativeFile((VirtualFile)dir, (String[])ArrayUtil.toStringArray((Collection)parts));
        }
        return null;
    }

    private static class MyState {
        @NotNull
        private final Factory<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final AtomicClearableLazyValue<Map<VirtualFile, JsonSchemaFileProvider>> myData;

        private MyState(@NotNull Factory<List<JsonSchemaFileProvider>> factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState", "<init>"));
            }
            this.myFactory = factory;
            this.myData = new AtomicClearableLazyValue<Map<VirtualFile, JsonSchemaFileProvider>>(){

                @NotNull
                public Map<VirtualFile, JsonSchemaFileProvider> compute() {
                    Map<VirtualFile, JsonSchemaFileProvider> map2 = Collections.unmodifiableMap(MyState.createFileProviderMap((List)myFactory.create()));
                    if (map2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState$1", "compute"));
                    }
                    return map2;
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        @NotNull
        public Collection<JsonSchemaFileProvider> getProviders() {
            Collection<JsonSchemaFileProvider> collection = ((Map)this.myData.getValue()).values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState", "getProviders"));
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set<VirtualFile> set2 = ((Map)this.myData.getValue()).keySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState", "getFiles"));
            }
            return set2;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState", "getProvider"));
            }
            return (JsonSchemaFileProvider)((Map)this.myData.getValue()).get(file2);
        }

        private static Map<VirtualFile, JsonSchemaFileProvider> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState", "createFileProviderMap"));
            }
            HashMap<VirtualFile, JsonSchemaFileProvider> map2 = new HashMap<VirtualFile, JsonSchemaFileProvider>();
            list2.stream().filter(provider -> provider.getSchemaFile() != null).forEach(provider -> map2.put(provider.getSchemaFile(), (JsonSchemaFileProvider)provider));
            return map2;
        }
    }
}

