/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaType {
    _string,
    _number,
    _integer,
    _object,
    _array,
    _boolean,
    _null,
    _any;


    public String getName() {
        return this.name().substring(1);
    }

    @Nullable
    static JsonSchemaType getType(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaType", "getType"));
        }
        if (value2.isNull()) {
            return _null;
        }
        if (value2.isBooleanLiteral()) {
            return _boolean;
        }
        if (value2.isStringLiteral()) {
            return _string;
        }
        if (value2.isArray()) {
            return _array;
        }
        if (value2.isObject()) {
            return _object;
        }
        if (value2.isNumberLiteral()) {
            return JsonSchemaType.isInteger(value2.getDelegate().getText()) ? _integer : _number;
        }
        return null;
    }

    private static boolean isInteger(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/jsonSchema/impl/JsonSchemaType", "isInteger"));
        }
        try {
            Integer.parseInt(text2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

