/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MatchResult {
    public final Set<JsonSchemaObject> mySchemas;
    public final List<Set<JsonSchemaObject>> myExcludingSchemas;

    private MatchResult(@NotNull Set<JsonSchemaObject> schemas, @NotNull List<Set<JsonSchemaObject>> excludingSchemas) {
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/jetbrains/jsonSchema/impl/MatchResult", "<init>"));
        }
        if (excludingSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludingSchemas", "com/jetbrains/jsonSchema/impl/MatchResult", "<init>"));
        }
        this.mySchemas = Collections.unmodifiableSet(schemas);
        this.myExcludingSchemas = Collections.unmodifiableList(excludingSchemas);
    }

    public static MatchResult create(@NotNull JsonSchemaTreeNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/jsonSchema/impl/MatchResult", "create"));
        }
        HashSet<JsonSchemaObject> schemas = new HashSet<JsonSchemaObject>();
        HashMap oneOfGroups = new HashMap();
        ContainerUtil.process((Iterable)((JBTreeTraverser)new JBTreeTraverser(node -> node.getChildren()).withRoot((Object)root)).preOrderDfsTraversal(), node -> {
            if (node.getChildren().isEmpty() && !node.isAny() && !node.isNothing() && SchemaResolveState.normal.equals((Object)node.getResolveState())) {
                int groupNumber = node.getExcludingGroupNumber();
                if (groupNumber < 0) {
                    schemas.add(node.getSchema());
                } else {
                    HashSet<JsonSchemaObject> set2 = (HashSet<JsonSchemaObject>)oneOfGroups.get(groupNumber);
                    if (set2 == null) {
                        set2 = new HashSet<JsonSchemaObject>();
                        oneOfGroups.put(groupNumber, set2);
                    }
                    set2.add(node.getSchema());
                }
            }
            return true;
        });
        return new MatchResult(schemas, new ArrayList<Set<JsonSchemaObject>>(oneOfGroups.values()));
    }
}

