/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceofChainInspection
extends BaseInspection {
    public boolean ignoreInstanceofOnLibraryClasses = false;

    @NotNull
    public String getID() {
        if ("ChainOfInstanceofChecks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "getID"));
        }
        return "ChainOfInstanceofChecks";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Check check = (Check)((Object)infos[0]);
        if (check == Check.CLASS_EQUALITY) {
            String string = InspectionGadgetsBundle.message("chain.of.class.equality.checks.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.instanceof.on.library.classes", new Object[0]), (InspectionProfileEntry)this, "ignoreInstanceofOnLibraryClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofChainVisitor();
    }

    private class InstanceofChainVisitor
    extends BaseInspectionVisitor {
        private InstanceofChainVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            PsiIfStatement previousIfStatement;
            PsiExpression condition2;
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/abstraction/InstanceofChainInspection$InstanceofChainVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(ifStatement);
            if (ControlFlowUtils.isElseIf(ifStatement)) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)ifStatement, PsiStatement.class);
            if (previousStatement instanceof PsiIfStatement && this.chainCheck(condition2 = (previousIfStatement = (PsiIfStatement)previousStatement).getCondition(), null) != Check.NEITHER) {
                return;
            }
            int numChecks = 0;
            PsiIfStatement branch = ifStatement;
            Check check = null;
            while (true) {
                PsiStatement nextStatement;
                PsiExpression condition3;
                Check chainCheck;
                if ((chainCheck = this.chainCheck(condition3 = branch.getCondition(), check)) == Check.NEITHER) {
                    if (numChecks > 1) break;
                    return;
                }
                check = chainCheck;
                ++numChecks;
                PsiStatement elseBranch = branch.getElseBranch();
                if (elseBranch instanceof PsiIfStatement) {
                    branch = (PsiIfStatement)elseBranch;
                    continue;
                }
                if (elseBranch != null || !((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)branch, PsiStatement.class)) instanceof PsiIfStatement)) break;
                branch = (PsiIfStatement)nextStatement;
            }
            if (numChecks < 2) {
                return;
            }
            this.registerStatementError((PsiStatement)ifStatement, new Object[]{check});
        }

        private Check chainCheck(PsiExpression condition2, Check check) {
            while (true) {
                if (condition2 == null) {
                    return Check.NEITHER;
                }
                if (check != Check.CLASS_EQUALITY && this.isInstanceofExpression(condition2)) {
                    return Check.INSTANCEOF;
                }
                if (condition2 instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands2;
                    if (check != Check.INSTANCEOF && this.isClassEqualityExpression(condition2)) {
                        return Check.CLASS_EQUALITY;
                    }
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
                    for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                        Check chainCheck = this.chainCheck(operand2, check);
                        if (chainCheck == Check.NEITHER) continue;
                        return chainCheck;
                    }
                    return Check.NEITHER;
                }
                if (condition2 instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition2;
                    condition2 = parenthesizedExpression.getExpression();
                    continue;
                }
                if (condition2 instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition2;
                    condition2 = prefixExpression.getOperand();
                    continue;
                }
                if (!(condition2 instanceof PsiPostfixExpression)) break;
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)condition2;
                condition2 = postfixExpression.getOperand();
            }
            return Check.NEITHER;
        }

        private boolean isClassEqualityExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            if (binaryExpression.getOperationTokenType() != JavaTokenType.EQEQ) {
                return false;
            }
            return this.isClassObjectAccessExpression(binaryExpression.getLOperand()) || this.isClassObjectAccessExpression(binaryExpression.getROperand());
        }

        private boolean isClassObjectAccessExpression(PsiExpression expression2) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)expression2;
            PsiTypeElement typeElement = classObjectAccessExpression.getOperand();
            return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || !LibraryUtil.isTypeInLibrary(typeElement.getType());
        }

        private boolean isInstanceofExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiInstanceOfExpression)) {
                return false;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            PsiTypeElement typeElement = instanceOfExpression.getCheckType();
            return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || typeElement == null || !LibraryUtil.isTypeInLibrary(typeElement.getType());
        }
    }

    private static enum Check {
        CLASS_EQUALITY,
        INSTANCEOF,
        NEITHER;

    }
}

