/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.annotation;

import com.intellij.codeInsight.daemon.impl.quickfix.AddAnnotationAttributeNameFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleElementAnnotationInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("single.element.annotation.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/annotation/SingleElementAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/annotation/SingleElementAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExpandAnnotationVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExpandAnnotationFix();
    }

    private static class ExpandAnnotationVisitor
    extends BaseInspectionVisitor {
        private ExpandAnnotationVisitor() {
        }

        public void visitNameValuePair(PsiNameValuePair pair2) {
            PsiAnnotationMemberValue value2;
            PsiType valueType;
            PsiElement resolved;
            PsiReference reference;
            Set<String> usedNames;
            PsiElement parent;
            super.visitNameValuePair(pair2);
            if (pair2.getName() == null && (parent = pair2.getParent()) instanceof PsiAnnotationParameterList && !(usedNames = AddAnnotationAttributeNameFix.getUsedAttributeNames((PsiAnnotationParameterList)parent)).contains("value") && (reference = pair2.getReference()) != null && (resolved = reference.resolve()) instanceof PsiMethod && AddAnnotationAttributeNameFix.isCompatibleReturnType((PsiMethod)resolved, valueType = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(value2 = pair2.getValue()))) {
                this.registerError((PsiElement)pair2, new Object[0]);
            }
        }
    }

    private static class ExpandAnnotationFix
    extends InspectionGadgetsFix {
        private ExpandAnnotationFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("single.element.annotation.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/annotation/SingleElementAnnotationInspection$ExpandAnnotationFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.element.annotation.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/annotation/SingleElementAnnotationInspection$ExpandAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiNameValuePair annotationParameter = (PsiNameValuePair)descriptor.getPsiElement();
            String text2 = ExpandAnnotationFix.buildReplacementText(annotationParameter);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotationParameter.getProject());
            PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text2 + " )", (PsiElement)annotationParameter);
            annotationParameter.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0]);
        }

        private static String buildReplacementText(@NotNull PsiNameValuePair annotationParameter) {
            if (annotationParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParameter", "com/siyeh/ig/annotation/SingleElementAnnotationInspection$ExpandAnnotationFix", "buildReplacementText"));
            }
            PsiAnnotationMemberValue value2 = annotationParameter.getValue();
            return "value=" + (value2 != null ? value2.getText() : "");
        }
    }
}

