/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractParameterAsLocalVariableFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAssignmentToParameterInspection
extends BaseInspection {
    public boolean ignoreTransformationOfOriginalParameter = false;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtractParameterAsLocalVariableFix();
    }

    protected abstract boolean isCorrectScope(PsiElement var1);

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new AssignmentToParameterVisitor();
    }

    private class AssignmentToParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/BaseAssignmentToParameterInspection$AssignmentToParameterVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression2);
            PsiExpression lhs = expression2.getLExpression();
            PsiParameter parameter = this.getParameter(lhs);
            if (parameter == null) {
                return;
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                PsiExpression rhs = expression2.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed((PsiVariable)parameter, (PsiElement)rhs)) {
                    return;
                }
                IElementType tokenType = expression2.getOperationTokenType();
                if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ || tokenType == JavaTokenType.ASTERISKEQ || tokenType == JavaTokenType.DIVEQ || tokenType == JavaTokenType.ANDEQ || tokenType == JavaTokenType.OREQ || tokenType == JavaTokenType.XOREQ || tokenType == JavaTokenType.PERCEQ || tokenType == JavaTokenType.LTLTEQ || tokenType == JavaTokenType.GTGTEQ || tokenType == JavaTokenType.GTGTGTEQ) {
                    return;
                }
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/BaseAssignmentToParameterInspection$AssignmentToParameterVisitor", "visitPrefixExpression"));
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                return;
            }
            super.visitPrefixExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiParameter parameter = this.getParameter(operand2);
            if (parameter == null) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/BaseAssignmentToParameterInspection$AssignmentToParameterVisitor", "visitPostfixExpression"));
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                return;
            }
            super.visitPostfixExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            PsiParameter parameter = this.getParameter(operand2);
            if (parameter == null) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }

        @Nullable
        private PsiParameter getParameter(PsiExpression expression2) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement variable = referenceExpression.resolve();
            if (!(variable instanceof PsiParameter)) {
                return null;
            }
            PsiParameter parameter = (PsiParameter)variable;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (!BaseAssignmentToParameterInspection.this.isCorrectScope(declarationScope)) {
                return null;
            }
            return parameter;
        }
    }
}

