/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

abstract class BaseEqualsVisitor
extends BaseInspectionVisitor {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object");
    private static final CallMatcher STATIC_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));

    BaseEqualsVisitor() {
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        super.visitMethodReferenceExpression(expression2);
        if (!OBJECT_EQUALS.methodReferenceMatches(expression2) && !STATIC_EQUALS.methodReferenceMatches(expression2)) {
            return;
        }
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)expression2.resolve(), PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        PsiType type1 = LambdaUtil.getLambdaParameterFromType((PsiType)functionalInterfaceType, (int)0);
        PsiType type2 = qualifier == null || qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)method.getContainingClass()) ? LambdaUtil.getLambdaParameterFromType((PsiType)functionalInterfaceType, (int)1) : qualifier.getType();
        this.checkTypes((PsiReferenceExpression)expression2, type1, type2);
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
        boolean staticEqualsCall;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/BaseEqualsVisitor", "visitMethodCallExpression"));
        }
        super.visitMethodCallExpression(expression2);
        if (OBJECT_EQUALS.test(expression2)) {
            staticEqualsCall = false;
        } else if (STATIC_EQUALS.test(expression2)) {
            staticEqualsCall = true;
        } else {
            return;
        }
        PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
        PsiExpression expression1 = arguments[0];
        PsiExpression expression22 = staticEqualsCall ? arguments[1] : ExpressionUtils.getQualifierOrThis(expression2.getMethodExpression());
        this.checkTypes(expression2.getMethodExpression(), expression1.getType(), expression22.getType());
    }

    abstract void checkTypes(PsiReferenceExpression var1, PsiType var2, PsiType var3);
}

