/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseEqualsVisitor(){

            @Override
            void checkTypes(PsiReferenceExpression expression2, PsiType type1, PsiType type2) {
                if (type1 != null && type2 != null && !TypeUtils.areConvertible(type1, type2)) {
                    PsiElement name2 = expression2.getReferenceNameElement();
                    this.registerError((PsiElement)(name2 == null ? expression2 : name2), type1, type2);
                }
            }
        };
    }
}

