/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsOnSuspiciousObjectInspection
extends BaseInspection {
    private List<String> myClasses = Arrays.asList("java.lang.StringBuilder", "java.lang.StringBuffer");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.problem.descriptor", StringUtil.getShortName((String)typeName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseEqualsVisitor(){

            @Override
            void checkTypes(PsiReferenceExpression expression2, PsiType type1, PsiType type2) {
                for (PsiType type3 : Arrays.asList(type1, type2)) {
                    if (!(type3 instanceof PsiClassType)) continue;
                    String text2 = ((PsiClassType)type3).rawType().getCanonicalText();
                    if (!EqualsOnSuspiciousObjectInspection.this.myClasses.contains(text2)) continue;
                    PsiElement name2 = expression2.getReferenceNameElement();
                    this.registerError((PsiElement)(name2 == null ? expression2 : name2), text2);
                    break;
                }
            }
        };
    }
}

