/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class ForLoopThatDoesntUseLoopVariableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean condition2 = (Boolean)infos[0];
        boolean update2 = (Boolean)infos[1];
        if (condition2 && update2) {
            String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.both.condition.and.update", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "buildErrorString"));
            }
            return string;
        }
        if (condition2) {
            String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.condition", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.update", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopThatDoesntUseLoopVariableVisitor();
    }

    private static class ForLoopThatDoesntUseLoopVariableVisitor
    extends BaseInspectionVisitor {
        private ForLoopThatDoesntUseLoopVariableVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            boolean notUsedInUpdate;
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection$ForLoopThatDoesntUseLoopVariableVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement2);
            PsiLocalVariable variable = ForLoopThatDoesntUseLoopVariableVisitor.extractInitializerVariable(statement2);
            if (variable == null) {
                return;
            }
            boolean notUsedInCondition = !ForLoopThatDoesntUseLoopVariableVisitor.conditionUsesVariable(statement2, variable);
            boolean bl = notUsedInUpdate = !ForLoopThatDoesntUseLoopVariableVisitor.updateUsesVariable(statement2, variable);
            if (notUsedInCondition || notUsedInUpdate) {
                if (!notUsedInCondition && ForLoopThatDoesntUseLoopVariableVisitor.isDeclarationUsedAsBound(statement2, variable)) {
                    return;
                }
                this.registerStatementError((PsiStatement)statement2, notUsedInCondition, notUsedInUpdate);
            }
        }

        private static boolean isDeclarationUsedAsBound(PsiForStatement statement2, PsiLocalVariable boundVar) {
            PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)statement2.getCondition()), PsiBinaryExpression.class);
            if (condition2 == null || !ComparisonUtils.isComparisonOperation(condition2.getOperationTokenType())) {
                return false;
            }
            PsiExpression otherOperand = null;
            if (ExpressionUtils.isReferenceTo(condition2.getLOperand(), (PsiVariable)boundVar)) {
                otherOperand = condition2.getROperand();
            } else if (ExpressionUtils.isReferenceTo(condition2.getROperand(), (PsiVariable)boundVar)) {
                otherOperand = condition2.getLOperand();
            }
            if (otherOperand == null) {
                return false;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)otherOperand), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiVariable indexVar = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (indexVar == null) {
                return false;
            }
            PsiStatement update2 = statement2.getUpdate();
            return VariableAccessUtils.variableIsIncremented(indexVar, update2) || VariableAccessUtils.variableIsDecremented(indexVar, update2);
        }

        private static PsiLocalVariable extractInitializerVariable(PsiForStatement statement2) {
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)statement2.getInitialization(), PsiDeclarationStatement.class);
            if (declaration2 == null) {
                return null;
            }
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            return (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
        }

        private static boolean conditionUsesVariable(PsiForStatement statement2, PsiLocalVariable variable) {
            PsiExpression condition2 = statement2.getCondition();
            return condition2 == null || VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)condition2);
        }

        private static boolean updateUsesVariable(PsiForStatement statement2, PsiLocalVariable variable) {
            PsiStatement update2 = statement2.getUpdate();
            return update2 == null || VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)update2);
        }
    }
}

