/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.negation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DoubleNegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    public static boolean isNegation(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiPrefixExpression) {
            return DoubleNegationInspection.isUnaryNegation((PsiPrefixExpression)expression2);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            return DoubleNegationInspection.isBinaryNegation((PsiPolyadicExpression)expression2);
        }
        return false;
    }

    static boolean isUnaryNegation(PsiPrefixExpression expression2) {
        return JavaTokenType.EXCL.equals(expression2.getOperationTokenType());
    }

    static boolean isBinaryNegation(PsiPolyadicExpression expression2) {
        for (PsiExpression operand2 : expression2.getOperands()) {
            if (!TypeUtils.hasFloatingPointType(operand2)) continue;
            return false;
        }
        return JavaTokenType.NE.equals(expression2.getOperationTokenType());
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (!DoubleNegationInspection.isUnaryNegation(expression2)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (!DoubleNegationInspection.isNegation(operand2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            if (!DoubleNegationInspection.isBinaryNegation(expression2)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length == 2) {
                int notNegatedCount = 0;
                for (PsiExpression operand2 : operands2) {
                    if (DoubleNegationInspection.isNegation(operand2)) continue;
                    ++notNegatedCount;
                }
                if (notNegatedCount > 1) {
                    return;
                }
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class DoubleNegationFix
    extends InspectionGadgetsFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement expression2 = descriptor.getPsiElement();
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiExpression operand2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, BoolUtils.getNegatedExpressionText(operand2));
            } else if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                PsiExpression[] operands2 = polyadicExpression.getOperands();
                int length = operands2.length;
                if (length == 2) {
                    PsiExpression firstOperand = operands2[0];
                    PsiExpression secondOperand = operands2[1];
                    if (DoubleNegationInspection.isNegation(firstOperand)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, BoolUtils.getNegatedExpressionText(firstOperand) + "==" + secondOperand.getText());
                    } else {
                        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, firstOperand.getText() + "==" + BoolUtils.getNegatedExpressionText(secondOperand));
                    }
                } else {
                    StringBuilder newExpressionText = new StringBuilder();
                    for (int i2 = 0; i2 < length; ++i2) {
                        if (i2 > 0) {
                            if (length % 2 != 1 && i2 == length - 1) {
                                newExpressionText.append("!=");
                            } else {
                                newExpressionText.append("==");
                            }
                        }
                        newExpressionText.append(operands2[i2].getText());
                    }
                    PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString());
                }
            }
        }
    }
}

