/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ForLoopReplaceableByWhileInspection
extends BaseInspection {
    public boolean m_ignoreLoopsWithoutConditions = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("ForLoopReplaceableByWhile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection", "getID"));
        }
        return "ForLoopReplaceableByWhile";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreLoopsWithoutConditions");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ForLoopReplaceableByWhileVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement2);
            PsiStatement initialization = statement2.getInitialization();
            if (initialization != null && !(initialization instanceof PsiEmptyStatement)) {
                return;
            }
            PsiStatement update2 = statement2.getUpdate();
            if (update2 != null && !(update2 instanceof PsiEmptyStatement)) {
                return;
            }
            if (ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithoutConditions) {
                PsiExpression condition2 = statement2.getCondition();
                if (condition2 == null) {
                    return;
                }
                String conditionText = condition2.getText();
                if ("true".equals(conditionText)) {
                    return;
                }
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }

    private static class ReplaceForByWhileFix
    extends InspectionGadgetsFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ReplaceForByWhileFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement forKeywordElement = descriptor.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)forKeywordElement.getParent();
            assert (forStatement != null);
            PsiExpression condition2 = forStatement.getCondition();
            PsiStatement body2 = forStatement.getBody();
            String bodyText = body2 == null ? "" : body2.getText();
            String whileStatement = condition2 == null ? "while(true)" + bodyText : "while(" + condition2.getText() + ')' + bodyText;
            PsiReplacementUtil.replaceStatement((PsiStatement)forStatement, whileStatement);
        }
    }
}

