/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("RedundantIfStatement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "getID"));
        }
        return "RedundantIfStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.if.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TrivialIfFix();
    }

    public static void simplify(PsiIfStatement statement2) {
        if (TrivialIfInspection.isSimplifiableAssignment(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssignment(statement2);
        } else if (TrivialIfInspection.isSimplifiableReturn(statement2)) {
            TrivialIfInspection.replaceSimplifiableReturn(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturn(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturn(statement2);
        } else if (TrivialIfInspection.isSimplifiableAssignmentNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssignmentNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableReturnNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableReturnNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitReturnNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignment(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignment(statement2);
        } else if (TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement2)) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignmentNegated(statement2);
        } else if (TrivialIfInspection.isSimplifiableAssert(statement2)) {
            TrivialIfInspection.replaceSimplifiableAssert(statement2);
        }
    }

    private static void replaceSimplifiableAssert(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        if (statement2.getElseBranch() != null) {
            return;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement2.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        if (assertCondition == null) {
            return;
        }
        PsiExpression replacementCondition = JavaPsiFacade.getElementFactory((Project)statement2.getProject()).createExpressionFromText(BoolUtils.isFalse(assertCondition) ? conditionText : conditionText + "||" + assertCondition.getText(), (PsiElement)statement2);
        assertCondition.replace((PsiElement)replacementCondition);
        statement2.replace((PsiElement)assertStatement);
    }

    private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = condition2.getText();
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
        assert (nextStatement != null);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturn(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)statement2, PsiComment.class);
        PsiElement parent = statement2.getParent();
        for (PsiComment comment : comments) {
            parent.addBefore(comment.copy(), (PsiElement)statement2);
        }
        String conditionText = condition2.getText();
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
    }

    private static void replaceSimplifiableAssignment(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)statement2, PsiComment.class), comment -> (PsiComment)comment.copy());
        String conditionText = condition2.getText();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator2 = assignmentExpression.getOperationSign();
        String operand2 = operator2.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiElement parent = statement2.getParent();
        for (PsiComment comment2 : comments) {
            parent.addBefore((PsiElement)comment2, (PsiElement)statement2);
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand2 + conditionText + ';');
    }

    private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement2) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prevStatement == null) {
            return;
        }
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = condition2.getText();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator2 = assignmentExpression.getOperationSign();
        String operand2 = operator2.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand2 + conditionText + ';');
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitAssignmentNegated(PsiIfStatement statement2) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator2 = assignmentExpression.getOperationSign();
        String operand2 = operator2.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand2 + conditionText + ';');
        assert (prevStatement != null);
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitReturnNegated(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class});
        if (nextStatement == null) {
            return;
        }
        PsiElement nextSibling = statement2.getNextSibling();
        if (nextSibling != nextStatement) {
            statement2.getParent().deleteChildRange(nextSibling, nextStatement.getPrevSibling());
        }
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturnNegated(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        String newStatement = "return " + conditionText + ';';
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, newStatement);
    }

    private static void replaceSimplifiableAssignmentNegated(PsiIfStatement statement2) {
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
        if (assignmentStatement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator2 = assignmentExpression.getOperationSign();
        String operand2 = operator2.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)statement2, lhsText + operand2 + conditionText + ';');
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public static boolean isTrivial(PsiIfStatement ifStatement) {
        if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
            return false;
        }
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement) || TrivialIfInspection.isSimplifiableReturn(ifStatement) || TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement) || TrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement) || TrivialIfInspection.isSimplifiableReturnNegated(ifStatement) || TrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement) || TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement) || TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement) || TrivialIfInspection.isSimplifiableAssert(ifStatement);
    }

    private static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableImplicitReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return TrivialIfInspection.isReturn(thenBranch, thenReturn) && TrivialIfInspection.isReturn(elseBranch, elseReturn);
    }

    private static boolean isSimplifiableReturn(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableReturnNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableReturn(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableReturn(PsiIfStatement ifStatement, String thenReturn, String elseReturn) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isReturn(thenBranch, thenReturn) && TrivialIfInspection.isReturn(elseBranch, elseReturn);
    }

    private static boolean isSimplifiableAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableAssignment(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "true", "false");
    }

    private static boolean isSimplifiableImplicitAssignmentNegated(PsiIfStatement ifStatement) {
        return TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement, "false", "true");
    }

    private static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement, String thenAssignment, String elseAssignment) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        return TrivialIfInspection.isSimplifiableAssignment(thenBranch, elseBranch, thenAssignment, elseAssignment);
    }

    private static boolean isSimplifiableAssignment(PsiStatement thenBranch, PsiStatement elseBranch, String thenAssignment, String elseAssignment) {
        if (!TrivialIfInspection.isAssignment(thenBranch, thenAssignment) || !TrivialIfInspection.isAssignment(elseBranch, elseAssignment)) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiAssignmentExpression thenExpression2 = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression elseExpression2 = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
        IElementType thenTokenType = thenExpression2.getOperationTokenType();
        if (!thenTokenType.equals(elseExpression2.getOperationTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression2.getLExpression();
        PsiExpression elseLhs = elseExpression2.getLExpression();
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs);
    }

    private static boolean isReturn(PsiStatement statement2, String value2) {
        if (!(statement2 instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
        PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
        return returnValue != null && value2.equals(returnValue.getText());
    }

    private static boolean isAssignment(PsiStatement statement2, String value2) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if (!(expression2 instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
        PsiExpression rhs = ParenthesesUtils.stripParentheses(assignment.getRExpression());
        return rhs != null && value2.equals(rhs.getText());
    }

    private static boolean isSimplifiableAssert(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return false;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        return assertStatement.getAssertCondition() != null;
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(ifStatement);
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            if (TrivialIfInspection.isTrivial(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
            }
        }
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement2 = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement2);
        }
    }
}

