/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class IntroduceVariableFix
extends RefactoringInspectionGadgetsFix {
    private final boolean myOnQualifier;

    public IntroduceVariableFix(boolean onQualifier) {
        this.myOnQualifier = onQualifier;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("introduce.variable.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceVariableFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        RefactoringActionHandler refactoringActionHandler = JavaRefactoringActionHandlerFactory.getInstance().createIntroduceVariableHandler();
        if (refactoringActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceVariableFix", "getHandler"));
        }
        return refactoringActionHandler;
    }

    public PsiElement getElementToRefactor(PsiElement element) {
        PsiElement parent = element.getParent();
        if (this.myOnQualifier) {
            if (parent instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)parent).getQualifierExpression();
            }
        } else if (parent instanceof PsiReferenceExpression) {
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof PsiMethodCallExpression ? grandParent : parent;
        }
        return super.getElementToRefactor(element);
    }
}

