/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        if (!FinalUtils.canBeFinal((PsiVariable)field)) {
            return null;
        }
        String name2 = field.getName();
        return new MakeFieldFinalFix(name2);
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(PsiField field) {
        MakeFieldFinalFix makeFieldFinalFix = new MakeFieldFinalFix(field.getName());
        if (makeFieldFinalFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeFieldFinalFix", "buildFixUnconditional"));
        }
        return makeFieldFinalFix;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.field.final.quickfix", this.fieldName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeFieldFinalFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Make final" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeFieldFinalFix", "getFamilyName"));
        }
        return "Make final";
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        PsiField field;
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiElement target2 = referenceExpression.resolve();
            if (!(target2 instanceof PsiField)) {
                return;
            }
            field = (PsiField)target2;
        } else {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiField)) {
                return;
            }
            field = (PsiField)parent;
        }
        field.normalizeDeclaration();
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("volatile", false);
        modifierList.setModifierProperty("final", true);
    }
}

